/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.http;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.jolokia.server.core.http.BackChannel;

public class ServletBackChannel
implements BackChannel {
    private HttpServletRequest request;
    private AsyncContext asyncContext;
    private boolean closed = true;

    public ServletBackChannel(HttpServletRequest pReq) {
        this.request = pReq;
    }

    @Override
    public synchronized void open(Map<String, ?> pParams) throws IOException {
        if (this.request == null) {
            throw new IllegalStateException("Channel has been already used and can't be reused. You need to create a new channel");
        }
        this.asyncContext = this.request.startAsync();
        this.setResponseHeaders(pParams);
        this.asyncContext.setTimeout(3600000L);
        this.asyncContext.getResponse().flushBuffer();
        this.closed = false;
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.asyncContext.complete();
            this.closed = true;
            this.request = null;
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.closed) {
            return this.asyncContext.getResponse().getOutputStream();
        }
        throw new IOException("Channel already closed");
    }

    private void setResponseHeaders(Map<String, ?> pParams) {
        ServletResponse response;
        if (pParams.containsKey("backChannel.contentType")) {
            this.asyncContext.getResponse().setContentType((String)pParams.get("backChannel.contentType"));
        }
        if (pParams.containsKey("backChannel.encoding")) {
            this.asyncContext.getResponse().setCharacterEncoding((String)pParams.get("backChannel.encoding"));
        }
        if ((response = this.asyncContext.getResponse()) instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        }
    }
}

