/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.extensions.spring.util;

import java.io.File;
import java.io.InputStream;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class ApplicationContextUtil {
    public static final String SPRING_APPLICATION_CONTEXT = "SpringApplicationContext";
    public static final String SPRING_APPLICATION_CONTEXT_LOCATION = "SpringContextLocation";

    public static GenericApplicationContext getSpringApplicationContext(AxisService axisService) throws AxisFault {
        Parameter appContextParameter = axisService.getParameter(SPRING_APPLICATION_CONTEXT);
        Parameter contextLocationParam = axisService.getParameter(SPRING_APPLICATION_CONTEXT_LOCATION);
        if (appContextParameter == null) {
            GenericApplicationContext appContext = new GenericApplicationContext();
            ClassLoader serviceCL = axisService.getClassLoader();
            appContext.setClassLoader(serviceCL);
            ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(serviceCL);
                XmlBeanDefinitionReader xbdr = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext);
                if (contextLocationParam != null) {
                    xbdr.loadBeanDefinitions((Resource)new ClassPathResource((String)contextLocationParam.getValue()));
                    appContext.refresh();
                    AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
                    Parameter springGroupCtxLocation = axisServiceGroup.getParameter(SPRING_APPLICATION_CONTEXT_LOCATION);
                    if (springGroupCtxLocation != null) {
                        axisServiceGroup.addParameter(new Parameter(SPRING_APPLICATION_CONTEXT, (Object)appContext));
                    } else {
                        axisService.addParameter(new Parameter(SPRING_APPLICATION_CONTEXT, (Object)appContext));
                    }
                    GenericApplicationContext genericApplicationContext = appContext;
                    return genericApplicationContext;
                }
                InputStream ctxFileInputStream = serviceCL.getResourceAsStream("META-INF" + File.separator + axisService.getName() + "-application-context.xml");
                if (ctxFileInputStream == null) {
                    ctxFileInputStream = serviceCL.getResourceAsStream("META-INF".toLowerCase() + File.separator + axisService.getName() + "-application-context.xml");
                }
                if (ctxFileInputStream != null) {
                    xbdr.setValidationMode(0);
                    xbdr.loadBeanDefinitions((Resource)new InputStreamResource(ctxFileInputStream));
                    appContext.refresh();
                    axisService.addParameter(new Parameter(SPRING_APPLICATION_CONTEXT, (Object)appContext));
                    GenericApplicationContext genericApplicationContext = appContext;
                    return genericApplicationContext;
                }
                try {
                    throw new AxisFault("Spring context file cannot be located for AxisService");
                }
                catch (Exception e) {
                    throw AxisFault.makeFault((Throwable)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCL);
            }
        }
        GenericApplicationContext appContext = (GenericApplicationContext)appContextParameter.getValue();
        return appContext;
    }
}

