/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base.endpoint.config;

import java.util.Iterator;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.base.endpoint.URLEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLEndpointFactory {
    private static final Log log = LogFactory.getLog(URLEndpointFactory.class);

    public URLEndpoint create(OMElement xml) throws AxisFault {
        OMAttribute urlPatternAttr = xml.getAttribute(new QName("urlPattern"));
        if (urlPatternAttr == null) {
            this.handleException("urlPattern attribute is mandory for an URLEndpoint configuration");
            return null;
        }
        String pattern = urlPatternAttr.getAttributeValue();
        URLEndpoint endpoint = new URLEndpoint(Pattern.compile(pattern));
        OMElement messageBuilders = xml.getFirstChildWithName(new QName("messageBuilders"));
        if (messageBuilders != null) {
            Builder builder;
            OMAttribute defaultBuilderAttr = messageBuilders.getAttribute(new QName("defaultBuilder"));
            if (defaultBuilderAttr != null && (builder = this.loadBuilder(defaultBuilderAttr.getAttributeValue())) != null) {
                endpoint.setDefaultBuilder(builder);
            }
            Iterator it = messageBuilders.getChildrenWithName(new QName("messageBuilder"));
            while (it.hasNext()) {
                Builder builder2;
                OMAttribute classAttr;
                OMElement builderElement = (OMElement)it.next();
                OMAttribute contentTypeAttr = builderElement.getAttribute(new QName("contentType"));
                if (contentTypeAttr == null) {
                    this.handleException("contentType attribute cannot be null for URLEndpoint with the urlPattern : " + pattern);
                }
                if ((classAttr = builderElement.getAttribute(new QName("class"))) == null) {
                    this.handleException("class attribute cannot be null for URLEndpoint with the urlPattern : " + pattern);
                }
                if (classAttr == null || contentTypeAttr == null || (builder2 = this.loadBuilder(classAttr.getAttributeValue())) == null) continue;
                endpoint.addBuilder(contentTypeAttr.getAttributeValue(), builder2);
            }
        }
        Iterator paramItr = xml.getChildrenWithName(new QName("parameter"));
        while (paramItr.hasNext()) {
            OMElement p = (OMElement)paramItr.next();
            OMAttribute paramNameAttr = p.getAttribute(new QName("name"));
            if (paramNameAttr == null) {
                this.handleException("Parameter name cannot be null");
                continue;
            }
            endpoint.addParameter(new Parameter(paramNameAttr.getAttributeValue(), (Object)p.getText()));
        }
        return endpoint;
    }

    private Builder loadBuilder(String name) throws AxisFault {
        try {
            if (name != null) {
                Class<?> c = Class.forName(name);
                Object o = c.newInstance();
                if (o instanceof Builder) {
                    return (Builder)o;
                }
                this.handleException("Class : " + name + " should be a Builder");
            }
        }
        catch (ClassNotFoundException e) {
            this.handleException("Error creating builder: " + name, e);
        }
        catch (InstantiationException e) {
            this.handleException("Error initializing builder: " + name, e);
        }
        catch (IllegalAccessException e) {
            this.handleException("Error initializing builder: " + name, e);
        }
        return null;
    }

    private void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

