/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.sjavac.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.openjdk.tools.javac.main.Main;
import org.openjdk.tools.sjavac.Log;
import org.openjdk.tools.sjavac.Util;
import org.openjdk.tools.sjavac.client.PortFileInaccessibleException;
import org.openjdk.tools.sjavac.options.OptionHelper;
import org.openjdk.tools.sjavac.options.Options;
import org.openjdk.tools.sjavac.server.PortFile;
import org.openjdk.tools.sjavac.server.Sjavac;
import org.openjdk.tools.sjavac.server.SjavacServer;

public class SjavacClient
implements Sjavac {
    private final String id;
    private final PortFile portFile;
    private final int keepalive;
    private final int poolsize;
    private final String sjavacForkCmd;
    static int CONNECTION_TIMEOUT = 2000;
    static int MAX_CONNECT_ATTEMPTS = 3;
    static int WAIT_BETWEEN_CONNECT_ATTEMPTS = 2000;
    private final String settings;

    public SjavacClient(Options options) {
        String string = options.getServerConf();
        String string2 = string != null ? string : "";
        String string3 = Util.extractStringOption("id", string2);
        this.id = string3 != null ? string3 : "id" + (new Random().nextLong() & Long.MAX_VALUE);
        String string4 = options.getDestDir().resolve("javac_server").toAbsolutePath().toString();
        String string5 = Util.extractStringOption("portfile", string2, string4);
        this.portFile = SjavacServer.getPortFile(string5);
        this.sjavacForkCmd = Util.extractStringOption("sjavac", string2, "sjavac");
        int n = Util.extractIntOption("poolsize", string2);
        this.keepalive = Util.extractIntOption("keepalive", string2, 120);
        this.poolsize = n > 0 ? n : Runtime.getRuntime().availableProcessors();
        this.settings = string2.equals("") ? "id=" + this.id + ",portfile=" + string5 : string2;
    }

    public String serverSettings() {
        return this.settings;
    }

    @Override
    public Main.Result compile(String[] stringArray) {
        Main.Result result = null;
        try (Socket socket = this.tryConnect();){
            String string;
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            printWriter.println(stringArray.length);
            Object object = stringArray;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                string = object[i];
                printWriter.println(string);
            }
            printWriter.flush();
            while (null != (object = bufferedReader.readLine())) {
                if (!((String)object).contains(":")) {
                    throw new AssertionError((Object)("Could not parse protocol line: >>\"" + (String)object + "\"<<"));
                }
                String[] stringArray2 = ((String)object).split(":", 2);
                String string2 = stringArray2[0];
                string = stringArray2[1];
                try {
                    if (Log.isDebugging()) {
                        string = "[sjavac-server] " + string;
                    }
                    Log.log(Log.Level.valueOf(string2), string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!string2.equals("RC")) continue;
                    result = Main.Result.valueOf(string);
                }
            }
        }
        catch (PortFileInaccessibleException portFileInaccessibleException) {
            Log.error("Port file inaccessible.");
            result = Main.Result.ERROR;
        }
        catch (IOException iOException) {
            Log.error("IOException caught during compilation: " + iOException.getMessage());
            Log.debug(iOException);
            result = Main.Result.ERROR;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            Log.error("Compilation interrupted.");
            Log.debug(interruptedException);
            result = Main.Result.ERROR;
        }
        if (result == null) {
            result = Main.Result.ERROR;
        }
        return result;
    }

    private Socket tryConnect() throws IOException, InterruptedException {
        this.makeSureServerIsRunning(this.portFile);
        int n = 0;
        while (true) {
            Log.debug("Trying to connect. Attempt " + ++n + " of " + MAX_CONNECT_ATTEMPTS);
            try {
                return this.makeConnectionAttempt();
            }
            catch (IOException iOException) {
                Log.error("Connection attempt failed: " + iOException.getMessage());
                if (n >= MAX_CONNECT_ATTEMPTS) {
                    Log.error("Giving up");
                    throw new IOException("Could not connect to server", iOException);
                }
                Thread.sleep(WAIT_BETWEEN_CONNECT_ATTEMPTS);
                continue;
            }
            break;
        }
    }

    private Socket makeConnectionAttempt() throws IOException {
        Socket socket = new Socket();
        InetAddress inetAddress = InetAddress.getByName(null);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.portFile.getPort());
        socket.connect(inetSocketAddress, CONNECTION_TIMEOUT);
        Log.debug("Connected");
        return socket;
    }

    private void makeSureServerIsRunning(PortFile portFile) throws IOException, InterruptedException {
        if (portFile.exists()) {
            portFile.lock();
            portFile.getValues();
            portFile.unlock();
            if (portFile.containsPortInfo()) {
                return;
            }
        }
        SjavacClient.fork(this.sjavacForkCmd, portFile, this.poolsize, this.keepalive);
    }

    @Override
    public void shutdown() {
    }

    public static void fork(String string, PortFile portFile, int n, int n2) throws IOException, InterruptedException {
        Process process;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(OptionHelper.unescapeCmdArg(string).split(" ")));
        arrayList.add("--startserver:portfile=" + portFile.getFilename() + ",poolsize=" + n + ",keepalive=" + n2);
        Log.debug("Starting server. Command: " + String.join((CharSequence)" ", arrayList));
        try {
            process = new ProcessBuilder(arrayList).redirectErrorStream(true).start();
        }
        catch (IOException iOException) {
            Log.error("Failed to create server process: " + iOException.getMessage());
            Log.debug(iOException);
            throw new IOException(iOException);
        }
        try {
            portFile.waitForValidValues();
        }
        catch (IOException iOException) {
            Log.error("Sjavac server failed to initialize: " + iOException.getMessage());
            Log.error("Process output:");
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                bufferedReader.lines().forEach(Log::error);
            }
            Log.error("<End of process output>");
            try {
                Log.error("Process exit code: " + process.exitValue());
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
            throw new IOException("Server failed to initialize: " + iOException.getMessage(), iOException);
        }
    }
}

