/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.sandesha2.storage.jdbc;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.sql.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistentBeanMgr {
	Log log = LogFactory.getLog(getClass());
	PersistentStorageManager pmgr = null;

	public PersistentBeanMgr(PersistentStorageManager pmgr) {
		this.pmgr = pmgr;
	}

	public Connection getDbConnection() {
		return pmgr.getDbConnection();
	}

	protected Object getObject(ResultSet rs, String field)
			throws Exception {
		// MySQL JDBC connector returns a byte array 
		// and Derby an EmbedBlob with :
		// return rs.getObject(field);
		// so
		InputStream bs = rs.getBinaryStream(field);
		if (bs == null) return null;
		return (new ObjectInputStream(bs)).readObject();
	}

	protected ByteArrayInputStream serialize(Object obj)
			throws Exception {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		ObjectOutputStream oos = new ObjectOutputStream(baos);
		oos.writeObject(obj);
		oos.close();
		ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
		return bais;
	}
}
