/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.report;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramLogWriter;
import org.apache.cassandra.stress.StressAction;
import org.apache.cassandra.stress.report.TimingInterval;
import org.apache.cassandra.stress.report.TimingIntervals;
import org.apache.cassandra.stress.settings.SettingsLog;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JmxCollector;
import org.apache.cassandra.stress.util.ResultLogger;
import org.apache.cassandra.stress.util.Uncertainty;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class StressMetrics
implements StressAction.MeasurementSink {
    private final List<StressAction.Consumer> consumers = new ArrayList<StressAction.Consumer>();
    private final ResultLogger output;
    private final Thread thread;
    private final Uncertainty rowRateUncertainty = new Uncertainty();
    private final CountDownLatch stopped = new CountDownLatch(1);
    private final Callable<JmxCollector.GcStats> gcStatsCollector;
    private final HistogramLogWriter histogramWriter;
    private final long epochNs = System.nanoTime();
    private final long epochMs = System.currentTimeMillis();
    private volatile JmxCollector.GcStats totalGcStats = new JmxCollector.GcStats(0.0);
    private volatile boolean stop = false;
    private volatile boolean cancelled = false;
    private final Map<String, TimingInterval> opTypeToCurrentTimingInterval = new TreeMap<String, TimingInterval>();
    private final Map<String, TimingInterval> opTypeToSummaryTimingInterval = new TreeMap<String, TimingInterval>();
    private final Queue<StressAction.OpMeasurement> leftovers = new ArrayDeque<StressAction.OpMeasurement>();
    private final TimingInterval totalCurrentInterval;
    private final TimingInterval totalSummaryInterval;
    public static final String HEADFORMAT = "%-50s%10s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%7s,%9s,%7s,%7s,%8s,%8s,%8s,%8s";
    public static final String ROWFORMAT = "%-50s%10d,%8.0f,%8.0f,%8.0f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%7.1f,%9.5f,%7d,%7.0f,%8.0f,%8.0f,%8.0f,%8.0f";
    public static final String[] HEADMETRICS = new String[]{"type", "total ops", "op/s", "pk/s", "row/s", "mean", "med", ".95", ".99", ".999", "max", "time", "stderr", "errors", "gc: #", "max ms", "sum ms", "sdv ms", "mb"};
    public static final String HEAD = String.format("%-50s%10s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%7s,%9s,%7s,%7s,%8s,%8s,%8s,%8s", HEADMETRICS);

    public StressMetrics(ResultLogger output, long logIntervalMillis, StressSettings settings) {
        Callable<JmxCollector.GcStats> gcStatsCollector;
        this.output = output;
        if (settings.log.hdrFile != null) {
            try {
                this.histogramWriter = new HistogramLogWriter(settings.log.hdrFile);
                this.histogramWriter.outputComment("Logging op latencies for Cassandra Stress");
                this.histogramWriter.outputLogFormatVersion();
                long roundedEpoch = this.epochMs - this.epochMs % 1000L;
                this.histogramWriter.outputBaseTime(roundedEpoch);
                this.histogramWriter.setBaseTime(roundedEpoch);
                this.histogramWriter.outputStartTime(roundedEpoch);
                this.histogramWriter.outputLegend();
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.histogramWriter = null;
        }
        this.totalGcStats = new JmxCollector.GcStats(0.0);
        try {
            gcStatsCollector = new JmxCollector(StressMetrics.toJmxNodes(settings.node.resolveAllPermitted(settings)), settings.port.jmxPort);
        }
        catch (Throwable t) {
            if (settings.log.level == SettingsLog.Level.VERBOSE) {
                t.printStackTrace();
            }
            System.err.println("Failed to connect over JMX; not collecting these stats");
            gcStatsCollector = () -> this.totalGcStats;
        }
        this.gcStatsCollector = gcStatsCollector;
        this.totalCurrentInterval = new TimingInterval(settings.rate.isFixed);
        this.totalSummaryInterval = new TimingInterval(settings.rate.isFixed);
        StressMetrics.printHeader("", output);
        this.thread = new Thread(() -> this.reportingLoop(logIntervalMillis));
        this.thread.setName("StressMetrics");
    }

    public void start() {
        this.thread.start();
    }

    public void waitUntilConverges(double targetUncertainty, int minMeasurements, int maxMeasurements) throws InterruptedException {
        this.rowRateUncertainty.await(targetUncertainty, minMeasurements, maxMeasurements);
    }

    public void cancel() {
        this.cancelled = true;
        this.stop = true;
        this.thread.interrupt();
        this.rowRateUncertainty.wakeAll();
    }

    public void stop() throws InterruptedException {
        this.stop = true;
        this.thread.interrupt();
        this.stopped.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportingLoop(long logIntervalMillis) {
        long currentTimeMs = System.currentTimeMillis();
        long startTimeMs = currentTimeMs - currentTimeMs % 1000L;
        long reportingStartNs = System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(currentTimeMs - startTimeMs);
        long parkIntervalNs = TimeUnit.MILLISECONDS.toNanos(logIntervalMillis);
        try {
            while (!this.stop) {
                long wakupTarget = reportingStartNs + parkIntervalNs;
                this.sleepUntil(wakupTarget);
                if (this.stop) break;
                this.recordInterval(wakupTarget, parkIntervalNs);
                reportingStartNs += parkIntervalNs;
            }
            long end = System.nanoTime();
            this.recordInterval(end, end - reportingStartNs);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cancel();
        }
        finally {
            this.rowRateUncertainty.wakeAll();
            this.stopped.countDown();
        }
    }

    private void sleepUntil(long until) {
        long parkFor;
        while (!this.stop && (parkFor = until - System.nanoTime()) > 0L) {
            LockSupport.parkNanos(parkFor);
        }
    }

    @Override
    public void record(String opType, long intended, long started, long ended, long rowCnt, long partitionCnt, boolean err) {
        TimingInterval current = this.opTypeToCurrentTimingInterval.computeIfAbsent(opType, k -> new TimingInterval(this.totalCurrentInterval.isFixed));
        this.record(current, intended, started, ended, rowCnt, partitionCnt, err);
    }

    private void record(TimingInterval t, long intended, long started, long ended, long rowCnt, long partitionCnt, boolean err) {
        t.rowCount += rowCnt;
        t.partitionCount += partitionCnt;
        if (err) {
            ++t.errorCount;
        }
        if (intended != 0L) {
            t.responseTime().recordValue(ended - intended);
            t.waitTime().recordValue(started - intended);
        }
        long sTime = ended - started;
        t.serviceTime().recordValue(sTime);
    }

    private void recordInterval(long intervalEnd, long parkIntervalNs) {
        this.drainConsumerMeasurements(intervalEnd, parkIntervalNs);
        JmxCollector.GcStats gcStats = null;
        try {
            gcStats = this.gcStatsCollector.call();
        }
        catch (Exception e) {
            gcStats = new JmxCollector.GcStats(0.0);
        }
        this.totalGcStats = JmxCollector.GcStats.aggregate(Arrays.asList(this.totalGcStats, gcStats));
        this.rowRateUncertainty.update(this.totalCurrentInterval.adjustedRowRate());
        if (this.totalCurrentInterval.operationCount() != 0L) {
            boolean logPerOpSummaryLine = this.opTypeToCurrentTimingInterval.size() > 1;
            for (Map.Entry<String, TimingInterval> type : this.opTypeToCurrentTimingInterval.entrySet()) {
                String opName = type.getKey();
                TimingInterval opInterval = type.getValue();
                if (logPerOpSummaryLine) {
                    StressMetrics.printRow("", opName, opInterval, this.opTypeToSummaryTimingInterval.get(opName), gcStats, this.rowRateUncertainty, this.output);
                }
                this.logHistograms(opName, opInterval);
                opInterval.reset();
            }
            StressMetrics.printRow("", "total", this.totalCurrentInterval, this.totalSummaryInterval, gcStats, this.rowRateUncertainty, this.output);
            this.totalCurrentInterval.reset();
        }
    }

    private void drainConsumerMeasurements(long intervalEnd, long parkIntervalNs) {
        int leftoversSize = this.leftovers.size();
        for (int i = 0; i < leftoversSize; ++i) {
            StressAction.OpMeasurement opMeasurement = this.leftovers.poll();
            if (opMeasurement.ended <= intervalEnd) {
                this.record(opMeasurement.opType, opMeasurement.intended, opMeasurement.started, opMeasurement.ended, opMeasurement.rowCnt, opMeasurement.partitionCnt, opMeasurement.err);
                this.consumers.get((int)(i % this.consumers.size())).measurementsRecycling.offer(opMeasurement);
                continue;
            }
            this.leftovers.offer(opMeasurement);
        }
        block1: for (StressAction.Consumer consumer : this.consumers) {
            StressAction.OpMeasurement last;
            Queue<StressAction.OpMeasurement> in = consumer.measurementsReporting;
            Queue<StressAction.OpMeasurement> out = consumer.measurementsRecycling;
            while ((last = in.poll()) != null) {
                if (last.ended > intervalEnd) {
                    this.leftovers.add(last);
                    continue block1;
                }
                this.record(last.opType, last.intended, last.started, last.ended, last.rowCnt, last.partitionCnt, last.err);
                out.offer(last);
            }
        }
        for (Map.Entry entry : this.opTypeToCurrentTimingInterval.entrySet()) {
            ((TimingInterval)entry.getValue()).endNanos(intervalEnd);
            ((TimingInterval)entry.getValue()).startNanos(intervalEnd - parkIntervalNs);
            TimingInterval summaryPerOp = this.opTypeToSummaryTimingInterval.computeIfAbsent((String)entry.getKey(), k -> new TimingInterval(this.totalCurrentInterval.isFixed));
            summaryPerOp.add((TimingInterval)entry.getValue());
            this.totalCurrentInterval.add((TimingInterval)entry.getValue());
        }
        this.totalCurrentInterval.endNanos(intervalEnd);
        this.totalCurrentInterval.startNanos(intervalEnd - parkIntervalNs);
        this.totalSummaryInterval.add(this.totalCurrentInterval);
    }

    private void logHistograms(String opName, TimingInterval opInterval) {
        if (this.histogramWriter == null) {
            return;
        }
        long startNs = opInterval.startNanos();
        long endNs = opInterval.endNanos();
        this.logHistogram(opName + "-st", startNs, endNs, opInterval.serviceTime());
        this.logHistogram(opName + "-rt", startNs, endNs, opInterval.responseTime());
        this.logHistogram(opName + "-wt", startNs, endNs, opInterval.waitTime());
    }

    private void logHistogram(String opName, long startNs, long endNs, Histogram histogram) {
        if (histogram.getTotalCount() != 0L) {
            histogram.setTag(opName);
            long relativeStartNs = startNs - this.epochNs;
            long startMs = (long)(1000.0 * ((double)(this.epochMs + TimeUnit.NANOSECONDS.toMillis(relativeStartNs)) / 1000.0));
            histogram.setStartTimeStamp(startMs);
            long relativeEndNs = endNs - this.epochNs;
            long endMs = (long)(1000.0 * ((double)(this.epochMs + TimeUnit.NANOSECONDS.toMillis(relativeEndNs)) / 1000.0));
            histogram.setEndTimeStamp(endMs);
            this.histogramWriter.outputIntervalHistogram((EncodableHistogram)histogram);
        }
    }

    @VisibleForTesting
    public static Set<String> toJmxNodes(Set<String> nodes) {
        return nodes.stream().map(n -> n.split(":")[0]).collect(Collectors.toSet());
    }

    private static void printHeader(String prefix, ResultLogger output) {
        output.println(prefix + HEAD);
    }

    private static void printRow(String prefix, String type, TimingInterval interval, TimingInterval total, JmxCollector.GcStats gcStats, Uncertainty opRateUncertainty, ResultLogger output) {
        output.println(prefix + String.format(ROWFORMAT, type + ",", total.operationCount(), interval.opRate(), interval.partitionRate(), interval.rowRate(), interval.meanLatencyMs(), interval.medianLatencyMs(), interval.latencyAtPercentileMs(95.0), interval.latencyAtPercentileMs(99.0), interval.latencyAtPercentileMs(99.9), interval.maxLatencyMs(), Float.valueOf((float)total.runTimeMs() / 1000.0f), opRateUncertainty.getUncertainty(), interval.errorCount, gcStats.count, gcStats.maxms, gcStats.summs, gcStats.sdvms, gcStats.bytes / 1048576.0));
    }

    public void summarise() {
        this.output.println("\n");
        this.output.println("Results:");
        TimingIntervals opHistory = new TimingIntervals(this.opTypeToSummaryTimingInterval);
        TimingInterval history = this.totalSummaryInterval;
        this.output.println(String.format("Op rate                   : %,8.0f op/s  %s", history.opRate(), opHistory.opRates()));
        this.output.println(String.format("Partition rate            : %,8.0f pk/s  %s", history.partitionRate(), opHistory.partitionRates()));
        this.output.println(String.format("Row rate                  : %,8.0f row/s %s", history.rowRate(), opHistory.rowRates()));
        this.output.println(String.format("Latency mean              : %6.1f ms %s", history.meanLatencyMs(), opHistory.meanLatencies()));
        this.output.println(String.format("Latency median            : %6.1f ms %s", history.medianLatencyMs(), opHistory.medianLatencies()));
        this.output.println(String.format("Latency 95th percentile   : %6.1f ms %s", history.latencyAtPercentileMs(95.0), opHistory.latenciesAtPercentile(95.0)));
        this.output.println(String.format("Latency 99th percentile   : %6.1f ms %s", history.latencyAtPercentileMs(99.0), opHistory.latenciesAtPercentile(99.0)));
        this.output.println(String.format("Latency 99.9th percentile : %6.1f ms %s", history.latencyAtPercentileMs(99.9), opHistory.latenciesAtPercentile(99.9)));
        this.output.println(String.format("Latency max               : %6.1f ms %s", history.maxLatencyMs(), opHistory.maxLatencies()));
        this.output.println(String.format("Total partitions          : %,10d %s", history.partitionCount, opHistory.partitionCounts()));
        this.output.println(String.format("Total errors              : %,10d %s", history.errorCount, opHistory.errorCounts()));
        this.output.println(String.format("Total GC count            : %,1.0f", this.totalGcStats.count));
        this.output.println(String.format("Total GC memory           : %s", FBUtilities.prettyPrintMemory((long)((long)this.totalGcStats.bytes), (boolean)true)));
        this.output.println(String.format("Total GC time             : %,6.1f seconds", this.totalGcStats.summs / 1000.0));
        this.output.println(String.format("Avg GC time               : %,6.1f ms", this.totalGcStats.summs / this.totalGcStats.count));
        this.output.println(String.format("StdDev GC time            : %,6.1f ms", this.totalGcStats.sdvms));
        this.output.println("Total operation time      : " + DurationFormatUtils.formatDuration((long)history.runTimeMs(), (String)"HH:mm:ss", (boolean)true));
        this.output.println("");
    }

    public static void summarise(List<String> ids, List<StressMetrics> summarise, ResultLogger out) {
        int idLen = 0;
        for (String id : ids) {
            idLen = Math.max(id.length(), idLen);
        }
        String formatstr = "%" + idLen + "s, ";
        StressMetrics.printHeader(String.format(formatstr, "id"), out);
        for (int i = 0; i < ids.size(); ++i) {
            for (Map.Entry<String, TimingInterval> type : summarise.get((int)i).opTypeToSummaryTimingInterval.entrySet()) {
                StressMetrics.printRow(String.format(formatstr, ids.get(i)), type.getKey(), type.getValue(), type.getValue(), summarise.get((int)i).totalGcStats, summarise.get((int)i).rowRateUncertainty, out);
            }
            TimingInterval hist = summarise.get((int)i).totalSummaryInterval;
            StressMetrics.printRow(String.format(formatstr, ids.get(i)), "total", hist, hist, summarise.get((int)i).totalGcStats, summarise.get((int)i).rowRateUncertainty, out);
        }
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public void add(StressAction.Consumer consumer) {
        this.consumers.add(consumer);
    }

    public double opRate() {
        return this.totalSummaryInterval.opRate();
    }
}

