/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;

class ColumnFamilyStoreMBeanIterator
implements Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> {
    private MBeanServerConnection mbeanServerConn;
    Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> mbeans;

    public ColumnFamilyStoreMBeanIterator(MBeanServerConnection mbeanServerConn) throws MalformedObjectNameException, NullPointerException, IOException {
        this.mbeanServerConn = mbeanServerConn;
        List<Map.Entry<String, ColumnFamilyStoreMBean>> cfMbeans = this.getCFSMBeans(mbeanServerConn, "ColumnFamilies");
        cfMbeans.addAll(this.getCFSMBeans(mbeanServerConn, "IndexColumnFamilies"));
        Collections.sort(cfMbeans, new Comparator<Map.Entry<String, ColumnFamilyStoreMBean>>(){

            @Override
            public int compare(Map.Entry<String, ColumnFamilyStoreMBean> e1, Map.Entry<String, ColumnFamilyStoreMBean> e2) {
                int keyspaceNameCmp = e1.getKey().compareTo(e2.getKey());
                if (keyspaceNameCmp != 0) {
                    return keyspaceNameCmp;
                }
                String[] e1CF = e1.getValue().getTableName().split("\\.");
                String[] e2CF = e2.getValue().getTableName().split("\\.");
                assert (e1CF.length <= 2 && e2CF.length <= 2) : "unexpected split count for table name";
                if (e1CF.length == 1 && e2CF.length == 1) {
                    return e1CF[0].compareTo(e2CF[0]);
                }
                int cfNameCmp = e1CF[0].compareTo(e2CF[0]);
                if (cfNameCmp != 0) {
                    return cfNameCmp;
                }
                if (e1CF.length == 2 && e2CF.length == 2) {
                    return e1CF[1].compareTo(e2CF[1]);
                }
                return e1CF.length == 1 ? 1 : -1;
            }
        });
        this.mbeans = cfMbeans.iterator();
    }

    private List<Map.Entry<String, ColumnFamilyStoreMBean>> getCFSMBeans(MBeanServerConnection mbeanServerConn, String type) throws MalformedObjectNameException, IOException {
        ObjectName query = new ObjectName("org.apache.cassandra.db:type=" + type + ",*");
        Set<ObjectName> cfObjects = mbeanServerConn.queryNames(query, null);
        ArrayList<Map.Entry<String, ColumnFamilyStoreMBean>> mbeans = new ArrayList<Map.Entry<String, ColumnFamilyStoreMBean>>(cfObjects.size());
        for (ObjectName n : cfObjects) {
            String keyspaceName = n.getKeyProperty("keyspace");
            ColumnFamilyStoreMBean cfsProxy = JMX.newMBeanProxy(mbeanServerConn, n, ColumnFamilyStoreMBean.class);
            mbeans.add(new AbstractMap.SimpleImmutableEntry<String, ColumnFamilyStoreMBean>(keyspaceName, cfsProxy));
        }
        return mbeans;
    }

    @Override
    public boolean hasNext() {
        return this.mbeans.hasNext();
    }

    @Override
    public Map.Entry<String, ColumnFamilyStoreMBean> next() {
        return this.mbeans.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

