/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Preconditions;
import org.apache.cassandra.db.ArrayClusteringBound;
import org.apache.cassandra.db.ArrayClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundary;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.utils.ObjectSizes;

public class ArrayClusteringBoundary
extends ArrayClusteringBoundOrBoundary
implements ClusteringBoundary<byte[]> {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new ArrayClusteringBoundary(ClusteringPrefix.Kind.INCL_START_BOUND, EMPTY_VALUES_ARRAY));

    public ArrayClusteringBoundary(ClusteringPrefix.Kind kind, byte[][] values) {
        super(kind, values);
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.values) + (long)((byte[][])this.values).length;
    }

    public static ClusteringBoundary<byte[]> create(ClusteringPrefix.Kind kind, byte[][] values) {
        Preconditions.checkArgument((boolean)kind.isBoundary(), (String)"Expected boundary clustering kind, got %s", (Object)((Object)kind));
        return new ArrayClusteringBoundary(kind, values);
    }

    @Override
    public ClusteringBoundary<byte[]> invert() {
        return ArrayClusteringBoundary.create(this.kind().invert(), (byte[][])this.values);
    }

    @Override
    public ClusteringBound<byte[]> openBound(boolean reversed) {
        return ArrayClusteringBound.create(this.kind.openBoundOfBoundary(reversed), (byte[][])this.values);
    }

    @Override
    public ClusteringBound<byte[]> closeBound(boolean reversed) {
        return ArrayClusteringBound.create(this.kind.closeBoundOfBoundary(reversed), (byte[][])this.values);
    }
}

