/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.util.Locale;
import junit.framework.TestCase;
import org.apache.commons.beanutils.locale.BaseLocaleConverter;

public class BaseLocaleConverterTestCase
extends TestCase {
    protected Locale origLocale;
    protected BaseLocaleConverter converter;
    protected Object result;
    protected Object defaultValue;
    protected Object expectedValue;
    protected Locale localizedLocale;
    protected String localizedDecimalPattern;
    protected String localizedIntegerPattern;
    protected String localizedDecimalValue;
    protected String localizedIntegerValue;
    protected Locale defaultLocale;
    protected String defaultDecimalPattern;
    protected String defaultIntegerPattern;
    protected String defaultDecimalValue;
    protected String defaultIntegerValue;
    protected String expectedDecimalValue;
    protected String expectedIntegerValue;

    public BaseLocaleConverterTestCase(String name) {
        super(name);
    }

    protected void convertInvalid(BaseLocaleConverter converter, Object expectedValue) {
        this.convertInvalid(converter, "", expectedValue);
    }

    protected void convertInvalid(BaseLocaleConverter converter, String msgId, Object expectedValue) {
        block4: {
            try {
                this.result = converter.convert((Object)"xyz");
                if (expectedValue == null) {
                    BaseLocaleConverterTestCase.fail((String)("Expected ConversionException if no default value " + msgId));
                }
            }
            catch (Exception e) {
                if (expectedValue == null) break block4;
                BaseLocaleConverterTestCase.fail((String)("Expected default value " + msgId + " threw " + e));
            }
        }
        if (expectedValue != null) {
            BaseLocaleConverterTestCase.assertEquals((String)("Check invalid conversion is default " + msgId), (Object)expectedValue, (Object)this.result);
        }
    }

    protected void convertNull(BaseLocaleConverter converter, Object expectedValue) {
        this.convertNull(converter, "", expectedValue);
    }

    protected void convertNull(BaseLocaleConverter converter, String msgId, Object expectedValue) {
        try {
            this.result = converter.convert(null);
        }
        catch (Exception e) {
            BaseLocaleConverterTestCase.fail((String)("Null conversion " + msgId + " threw " + e));
        }
        if (expectedValue == null) {
            BaseLocaleConverterTestCase.assertNull((String)("Check null conversion is null " + msgId + " result=" + this.result), (Object)this.result);
        } else {
            BaseLocaleConverterTestCase.assertEquals((String)("Check null conversion is default " + msgId), (Object)expectedValue, (Object)this.result);
        }
    }

    protected void convertValueNoPattern(BaseLocaleConverter converter, Object value, Object expectedValue) {
        this.convertValueNoPattern(converter, "", value, expectedValue);
    }

    protected void convertValueNoPattern(BaseLocaleConverter converter, String msgId, Object value, Object expectedValue) {
        try {
            this.result = converter.convert(value);
        }
        catch (Exception e) {
            BaseLocaleConverterTestCase.fail((String)("No Pattern conversion threw " + msgId + " threw " + e));
        }
        BaseLocaleConverterTestCase.assertEquals((String)("Check conversion value without pattern " + msgId), (Object)expectedValue, (Object)this.result);
    }

    protected void convertValueToType(BaseLocaleConverter converter, Class<?> clazz, Object value, String pattern, Object expectedValue) {
        this.convertValueToType(converter, "", clazz, value, pattern, expectedValue);
    }

    protected void convertValueToType(BaseLocaleConverter converter, String msgId, Class<?> clazz, Object value, String pattern, Object expectedValue) {
        try {
            this.result = converter.convert(clazz, value, pattern);
        }
        catch (Exception e) {
            BaseLocaleConverterTestCase.fail((String)("Type  conversion threw " + msgId + " threw " + e));
        }
        BaseLocaleConverterTestCase.assertEquals((String)("Check conversion value to type " + msgId), (Object)expectedValue, (Object)this.result);
    }

    protected void convertValueWithPattern(BaseLocaleConverter converter, Object value, String pattern, Object expectedValue) {
        this.convertValueWithPattern(converter, "", value, pattern, expectedValue);
    }

    protected void convertValueWithPattern(BaseLocaleConverter converter, String msgId, Object value, String pattern, Object expectedValue) {
        try {
            this.result = converter.convert(value, pattern);
        }
        catch (Exception e) {
            BaseLocaleConverterTestCase.fail((String)("Pattern conversion threw " + msgId + " threw " + e));
        }
        BaseLocaleConverterTestCase.assertEquals((String)("Check conversion value with pattern " + msgId), (Object)expectedValue, (Object)this.result);
    }

    public void setUp() throws Exception {
        this.defaultLocale = Locale.US;
        this.defaultDecimalPattern = "#,###.00";
        this.defaultIntegerPattern = "#,###";
        this.defaultDecimalValue = "1,234.56";
        this.defaultIntegerValue = "1,234";
        this.localizedLocale = Locale.GERMAN;
        this.localizedDecimalPattern = "#.###,00";
        this.localizedIntegerPattern = "#.###";
        this.localizedDecimalValue = "1.234,56";
        this.localizedIntegerValue = "1.234";
        this.expectedDecimalValue = "1234.56";
        this.expectedIntegerValue = "1234";
        this.origLocale = Locale.getDefault();
        this.converter = null;
        this.result = null;
        this.defaultValue = null;
        this.expectedValue = null;
        if (this.defaultLocale.equals(this.origLocale)) {
            this.origLocale = null;
        } else {
            Locale.setDefault(this.defaultLocale);
        }
    }

    public void tearDown() {
        this.converter = null;
        this.result = null;
        this.defaultValue = null;
        this.expectedValue = null;
        if (this.origLocale != null) {
            Locale.setDefault(this.origLocale);
        }
    }

    public void testNothing() {
    }
}

