/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.expression;

import org.apache.commons.beanutils2.expression.DefaultResolver;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultResolverTest {
    private final DefaultResolver resolver = new DefaultResolver();
    private final String[] validProperties = new String[]{null, "", "a", "bc", "def", "g.h", "ij.k", "lm.no", "pqr.stu"};
    private final String[] validNames = new String[]{null, "", "a", "bc", "def", "g", "ij", "lm", "pqr"};
    private final String[] validIndexProperties = new String[]{"a[1]", "b[12]", "cd[3]", "ef[45]", "ghi[6]", "jkl[789]"};
    private final String[] validIndexNames = new String[]{"a", "b", "cd", "ef", "ghi", "jkl"};
    private final int[] validIndexValues = new int[]{1, 12, 3, 45, 6, 789};
    private final String[] validMapProperties = new String[]{"a(b)", "c(de)", "fg(h)", "ij(kl)", "mno(pqr.s)", "tuv(wx).yz[1]"};
    private final String[] validMapNames = new String[]{"a", "c", "fg", "ij", "mno", "tuv"};
    private final String[] validMapKeys = new String[]{"b", "de", "h", "kl", "pqr.s", "wx"};
    private final String[] nextExpressions = new String[]{"a", "bc", "d.e", "fg.h", "ij.kl", "m(12)", "no(3.4)", "pq(r).s", "t[12]", "uv[34].wx"};
    private final String[] nextProperties = new String[]{"a", "bc", "d", "fg", "ij", "m(12)", "no(3.4)", "pq(r)", "t[12]", "uv[34]"};
    private final String[] removeProperties = new String[]{null, null, "e", "h", "kl", null, null, "s", null, "wx"};

    private String label(String expression, int i) {
        return "Expression[" + i + "]=\"" + expression + "\"";
    }

    @BeforeEach
    protected void setUp() {
    }

    @AfterEach
    protected void tearDown() {
    }

    @Test
    public void testGetIndex() throws Exception {
        int i;
        String label = null;
        for (i = 0; i < this.validProperties.length; ++i) {
            label = "Simple " + this.label(this.validProperties[i], i);
            Assertions.assertEquals((int)-1, (int)this.resolver.getIndex(this.validProperties[i]), (String)label);
        }
        for (i = 0; i < this.validIndexProperties.length; ++i) {
            label = "Indexed " + this.label(this.validIndexProperties[i], i);
            Assertions.assertEquals((int)this.validIndexValues[i], (int)this.resolver.getIndex(this.validIndexProperties[i]), (String)label);
        }
        for (i = 0; i < this.validMapProperties.length; ++i) {
            label = "Mapped " + this.label(this.validMapProperties[i], i);
            Assertions.assertEquals((int)-1, (int)this.resolver.getIndex(this.validMapProperties[i]), (String)label);
        }
        label = "Missing Index";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.resolver.getIndex("foo[]"));
        label = "Malformed";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.resolver.getIndex("foo[12"));
        label = "Malformed";
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.resolver.getIndex("foo[BAR]"));
        Assertions.assertEquals((Object)"Invalid index value 'BAR'", (Object)e.getMessage(), (String)(label + " Error Message"));
    }

    @Test
    public void testGetMapKey() {
        int i;
        String label = null;
        for (i = 0; i < this.validProperties.length; ++i) {
            label = "Simple " + this.label(this.validProperties[i], i);
            Assertions.assertEquals(null, (Object)this.resolver.getKey(this.validProperties[i]), (String)label);
        }
        for (i = 0; i < this.validIndexProperties.length; ++i) {
            label = "Indexed " + this.label(this.validIndexProperties[i], i);
            Assertions.assertEquals(null, (Object)this.resolver.getKey(this.validIndexProperties[i]), (String)label);
        }
        for (i = 0; i < this.validMapProperties.length; ++i) {
            label = "Mapped " + this.label(this.validMapProperties[i], i);
            Assertions.assertEquals((Object)this.validMapKeys[i], (Object)this.resolver.getKey(this.validMapProperties[i]), (String)label);
        }
        label = "Malformed";
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.resolver.getKey("foo(bar"));
        Assertions.assertEquals((Object)"Missing End Delimiter", (Object)e.getMessage(), (String)(label + " Error Message"));
    }

    @Test
    public void testGetName() {
        int i;
        String label = null;
        for (i = 0; i < this.validProperties.length; ++i) {
            label = "Simple " + this.label(this.validProperties[i], i);
            Assertions.assertEquals((Object)this.validNames[i], (Object)this.resolver.getProperty(this.validProperties[i]), (String)label);
        }
        for (i = 0; i < this.validIndexProperties.length; ++i) {
            label = "Indexed " + this.label(this.validIndexProperties[i], i);
            Assertions.assertEquals((Object)this.validIndexNames[i], (Object)this.resolver.getProperty(this.validIndexProperties[i]), (String)label);
        }
        for (i = 0; i < this.validMapProperties.length; ++i) {
            label = "Mapped " + this.label(this.validMapProperties[i], i);
            Assertions.assertEquals((Object)this.validMapNames[i], (Object)this.resolver.getProperty(this.validMapProperties[i]), (String)label);
        }
    }

    @Test
    public void testIsIndexed() {
        int i;
        String label = null;
        for (i = 0; i < this.validProperties.length; ++i) {
            label = "Simple " + this.label(this.validProperties[i], i);
            Assertions.assertFalse((boolean)this.resolver.isIndexed(this.validProperties[i]), (String)label);
        }
        for (i = 0; i < this.validIndexProperties.length; ++i) {
            label = "Indexed " + this.label(this.validIndexProperties[i], i);
            Assertions.assertTrue((boolean)this.resolver.isIndexed(this.validIndexProperties[i]), (String)label);
        }
        for (i = 0; i < this.validMapProperties.length; ++i) {
            label = "Mapped " + this.label(this.validMapProperties[i], i);
            Assertions.assertFalse((boolean)this.resolver.isIndexed(this.validMapProperties[i]), (String)label);
        }
    }

    @Test
    public void testIsMapped() {
        int i;
        String label = null;
        for (i = 0; i < this.validProperties.length; ++i) {
            label = "Simple " + this.label(this.validProperties[i], i);
            Assertions.assertFalse((boolean)this.resolver.isMapped(this.validProperties[i]), (String)label);
        }
        for (i = 0; i < this.validIndexProperties.length; ++i) {
            label = "Indexed " + this.label(this.validIndexProperties[i], i);
            Assertions.assertFalse((boolean)this.resolver.isMapped(this.validIndexProperties[i]), (String)label);
        }
        for (i = 0; i < this.validMapProperties.length; ++i) {
            label = "Mapped " + this.label(this.validMapProperties[i], i);
            Assertions.assertTrue((boolean)this.resolver.isMapped(this.validMapProperties[i]), (String)label);
        }
    }

    @Test
    public void testNext() {
        String label = null;
        for (int i = 0; i < this.nextExpressions.length; ++i) {
            label = this.label(this.nextExpressions[i], i);
            Assertions.assertEquals((Object)this.nextProperties[i], (Object)this.resolver.next(this.nextExpressions[i]), (String)label);
        }
    }

    @Test
    public void testRemove() {
        String label = null;
        for (int i = 0; i < this.nextExpressions.length; ++i) {
            label = this.label(this.nextExpressions[i], i);
            Assertions.assertEquals((Object)this.removeProperties[i], (Object)this.resolver.remove(this.nextExpressions[i]), (String)label);
        }
    }
}

