/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.HashMap;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.commons.exec.TestUtil;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.lang3.SystemProperties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junitpioneer.jupiter.SetSystemProperty;

@SetSystemProperty.SetSystemProperties(value={@SetSystemProperty(key="org.apache.commons.exec.lenient", value="false"), @SetSystemProperty(key="org.apache.commons.exec.debug", value="true")})
class DefaultExecutorTest {
    private static final int WAITFOR_TIMEOUT = 15000;
    private static final Duration WAITFOR_TIMEOUT_D = Duration.ofMillis(15000L);
    private static int successStatus;
    private static int errorStatus;
    private final Executor exec = DefaultExecutor.builder().get();
    private final File testDir = new File("src/test/scripts");
    private final File foreverOutputFile = new File("./target/forever.txt");
    private ByteArrayOutputStream baos;
    private final Path testScript = TestUtil.resolveScriptPathForOS(this.testDir + "/test");
    private final Path errorTestScript = TestUtil.resolveScriptPathForOS(this.testDir + "/error");
    private final Path foreverTestScript = TestUtil.resolveScriptPathForOS(this.testDir + "/forever");
    private final Path nonExistingTestScript = TestUtil.resolveScriptPathForOS(this.testDir + "/grmpffffff");
    private final Path redirectScript = TestUtil.resolveScriptPathForOS(this.testDir + "/redirect");
    private final Path printArgsScript = TestUtil.resolveScriptPathForOS(this.testDir + "/printargs");
    private final Path stdinSript = TestUtil.resolveScriptPathForOS(this.testDir + "/stdin");
    private final Path environmentSript = TestUtil.resolveScriptPathForOS(this.testDir + "/environment");

    DefaultExecutorTest() {
    }

    @BeforeAll
    public static void classSetUp() {
        int[] statuses = TestUtil.getTestScriptCodesForOS();
        successStatus = statuses[0];
        errorStatus = statuses[1];
    }

    private int getOccurrences(String data, char c) {
        int result = 0;
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) != c) continue;
            ++result;
        }
        return result;
    }

    private String readFile(File file) throws Exception {
        StringBuilder contents = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String text;
            while ((text = reader.readLine()) != null) {
                contents.append(text).append(System.lineSeparator());
            }
        }
        return contents.toString();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.foreverOutputFile.getParentFile().mkdirs();
        if (this.foreverOutputFile.exists()) {
            this.foreverOutputFile.delete();
        }
        this.baos = new ByteArrayOutputStream();
        this.exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)this.baos, (OutputStream)this.baos));
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.baos.close();
        this.foreverOutputFile.delete();
    }

    @Test
    void testAddEnvironmentVariableEmbeddedQuote() throws Exception {
        HashMap<String, String> myEnvVars = new HashMap<String, String>(EnvironmentUtils.getProcEnvironment());
        String name = "NEW_VAR";
        String value = "NEW_\"_VAL";
        myEnvVars.put("NEW_VAR", "NEW_\"_VAL");
        this.exec.execute(new CommandLine(this.environmentSript), myEnvVars);
        String environment = this.baos.toString().trim();
        Assertions.assertTrue((boolean)environment.contains("NEW_VAR"), () -> "Expecting NEW_VAR in " + environment);
        Assertions.assertTrue((boolean)environment.contains("NEW_\"_VAL"), () -> "Expecting NEW_\"_VAL in " + environment);
    }

    @Test
    void testAddEnvironmentVariables() throws Exception {
        HashMap<String, String> myEnvVars = new HashMap<String, String>(EnvironmentUtils.getProcEnvironment());
        myEnvVars.put("NEW_VAR", "NEW_VAL");
        this.exec.execute(new CommandLine(this.environmentSript), myEnvVars);
        String environment = this.baos.toString().trim();
        Assertions.assertTrue((boolean)environment.contains("NEW_VAR"), () -> "Expecting NEW_VAR in " + environment);
        Assertions.assertTrue((boolean)environment.contains("NEW_VAL"), () -> "Expecting NEW_VAL in " + environment);
    }

    @Test
    void testEnvironmentVariables() throws Exception {
        this.exec.execute(new CommandLine(this.environmentSript));
        String environment = this.baos.toString().trim();
        Assertions.assertFalse((boolean)environment.isEmpty(), (String)"Found no environment variables");
        Assertions.assertFalse((boolean)environment.contains("NEW_VAR"));
    }

    @Test
    void testExecute() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        int exitValue = this.exec.execute(cl);
        Assertions.assertEquals((Object)"FOO..", (Object)this.baos.toString().trim());
        Assertions.assertFalse((boolean)this.exec.isFailure(exitValue));
        Assertions.assertEquals((Object)new File("."), (Object)this.exec.getWorkingDirectory());
        Assertions.assertEquals((Object)Paths.get(".", new String[0]), (Object)this.exec.getWorkingDirectoryPath());
    }

    @Test
    void testExecuteAsync() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        this.exec.execute(cl, (ExecuteResultHandler)resultHandler);
        resultHandler.waitFor(2000L);
        Assertions.assertTrue((boolean)resultHandler.hasResult());
        Assertions.assertNull((Object)resultHandler.getException());
        Assertions.assertFalse((boolean)this.exec.isFailure(resultHandler.getExitValue()));
        Assertions.assertEquals((Object)"FOO..", (Object)this.baos.toString().trim());
    }

    @Test
    void testExecuteAsyncNonExistingApplication() throws Exception {
        CommandLine cl = new CommandLine(this.nonExistingTestScript);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.execute(cl, (ExecuteResultHandler)resultHandler);
        resultHandler.waitFor();
        Assertions.assertTrue((boolean)executor.isFailure(resultHandler.getExitValue()));
        Assertions.assertNotNull((Object)resultHandler.getException());
    }

    @Test
    void testExecuteAsyncNonExistingApplicationWithWatchdog() throws Exception {
        CommandLine cl = new CommandLine(this.nonExistingTestScript);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler(){

            public void onProcessFailed(ExecuteException e) {
                System.out.println("Process did not stop gracefully, had exception '" + e.getMessage() + "' while executing process");
                super.onProcessFailed(e);
            }
        };
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.setWatchdog(new ExecuteWatchdog(-1L));
        executor.execute(cl, (ExecuteResultHandler)resultHandler);
        resultHandler.waitFor();
        Assertions.assertTrue((boolean)executor.isFailure(resultHandler.getExitValue()));
        Assertions.assertNotNull((Object)resultHandler.getException());
        Assertions.assertFalse((boolean)executor.getWatchdog().isWatching());
        Assertions.assertFalse((boolean)executor.getWatchdog().killedProcess());
        executor.getWatchdog().destroyProcess();
    }

    @Test
    void testExecuteAsyncWithError() throws Exception {
        CommandLine cl = new CommandLine(this.errorTestScript);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        this.exec.execute(cl, (ExecuteResultHandler)resultHandler);
        resultHandler.waitFor(2000L);
        Assertions.assertTrue((boolean)resultHandler.hasResult());
        Assertions.assertTrue((boolean)this.exec.isFailure(resultHandler.getExitValue()));
        Assertions.assertNotNull((Object)resultHandler.getException());
        Assertions.assertEquals((Object)"FOO..", (Object)this.baos.toString().trim());
    }

    @Test
    void testExecuteAsyncWithProcessDestroyer() throws Exception {
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        ShutdownHookProcessDestroyer processDestroyer = new ShutdownHookProcessDestroyer();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(Integer.MAX_VALUE);
        Assertions.assertNull((Object)this.exec.getProcessDestroyer());
        Assertions.assertTrue((boolean)processDestroyer.isEmpty());
        Assertions.assertFalse((boolean)processDestroyer.isAddedAsShutdownHook());
        this.exec.setWatchdog(watchdog);
        this.exec.setProcessDestroyer((ProcessDestroyer)processDestroyer);
        this.exec.execute(cl, (ExecuteResultHandler)handler);
        Thread.sleep(2000L);
        Assertions.assertNotNull((Object)this.exec.getProcessDestroyer(), (String)"Process destroyer should exist");
        Assertions.assertEquals((int)1, (int)processDestroyer.size(), (String)"Process destroyer size should be 1");
        Assertions.assertTrue((boolean)processDestroyer.isAddedAsShutdownHook(), (String)"Process destroyer should exist as shutdown hook");
        watchdog.destroyProcess();
        Assertions.assertTrue((boolean)watchdog.killedProcess());
        handler.waitFor(15000L);
        Assertions.assertTrue((boolean)handler.hasResult(), (String)"ResultHandler received a result");
        Assertions.assertNotNull((Object)handler.getException());
        Assertions.assertEquals((int)0, (int)processDestroyer.size(), (String)"Processor Destroyer size should be 0");
        Assertions.assertFalse((boolean)processDestroyer.isAddedAsShutdownHook(), (String)"Process destroyer should not exist as shutdown hook");
    }

    @Test
    void testExecuteAsyncWithTimelyUserTermination() throws Exception {
        CommandLine cl = new CommandLine(this.foreverTestScript);
        ExecuteWatchdog watchdog = new ExecuteWatchdog(Integer.MAX_VALUE);
        this.exec.setWatchdog(watchdog);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        this.exec.execute(cl, (ExecuteResultHandler)handler);
        Thread.sleep(2000L);
        Assertions.assertTrue((boolean)watchdog.isWatching(), (String)"Watchdog should watch the process");
        watchdog.destroyProcess();
        handler.waitFor(15000L);
        Assertions.assertTrue((boolean)watchdog.killedProcess(), (String)"Watchdog should have killed the process");
        Assertions.assertFalse((boolean)watchdog.isWatching(), (String)"Watchdog is no longer watching the process");
        Assertions.assertTrue((boolean)handler.hasResult(), (String)"ResultHandler received a result");
        Assertions.assertNotNull((Object)handler.getException(), (String)"ResultHandler received an exception as result");
    }

    @Test
    void testExecuteAsyncWithTooLateUserTermination() throws Exception {
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(3000L);
        this.exec.setWatchdog(watchdog);
        this.exec.execute(cl, (ExecuteResultHandler)handler);
        Thread.sleep(6000L);
        watchdog.destroyProcess();
        handler.waitFor(15000L);
        Assertions.assertTrue((boolean)watchdog.killedProcess(), (String)"Watchdog should have killed the process already");
        Assertions.assertFalse((boolean)watchdog.isWatching(), (String)"Watchdog is no longer watching the process");
        Assertions.assertTrue((boolean)handler.hasResult(), (String)"ResultHandler received a result");
        Assertions.assertNotNull((Object)handler.getException(), (String)"ResultHandler received an exception as result");
    }

    @Test
    void testExecuteNonExistingApplication() throws Exception {
        CommandLine cl = new CommandLine(this.nonExistingTestScript);
        DefaultExecutor executor = DefaultExecutor.builder().get();
        Assertions.assertThrows(IOException.class, () -> executor.execute(cl));
    }

    @Test
    void testExecuteNonExistingApplicationWithWatchDog() throws Exception {
        CommandLine cl = new CommandLine(this.nonExistingTestScript);
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.setWatchdog(new ExecuteWatchdog(-1L));
        Assertions.assertThrows(IOException.class, () -> executor.execute(cl));
    }

    @Test
    @Disabled
    void testExecuteStability() throws Exception {
        HashMap<String, String> env;
        int i;
        for (i = 0; i < 100; ++i) {
            env = new HashMap<String, String>();
            env.put("TEST_ENV_VAR", Integer.toString(i));
            CommandLine cl = new CommandLine(this.testScript);
            int exitValue = this.exec.execute(cl, env);
            Assertions.assertFalse((boolean)this.exec.isFailure(exitValue));
            Assertions.assertEquals((Object)("FOO." + i + "."), (Object)this.baos.toString().trim());
            this.baos.reset();
        }
        for (i = 0; i < 100; ++i) {
            env = new HashMap();
            env.put("TEST_ENV_VAR", Integer.toString(i));
            DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
            CommandLine cl = new CommandLine(this.foreverTestScript);
            ExecuteWatchdog watchdog = new ExecuteWatchdog(500L);
            this.exec.setWatchdog(watchdog);
            this.exec.execute(cl, env, (ExecuteResultHandler)resultHandler);
            resultHandler.waitFor(15000L);
            Assertions.assertTrue((boolean)resultHandler.hasResult(), (String)"ResultHandler received a result");
            Assertions.assertNotNull((Object)resultHandler.getException());
            this.baos.reset();
        }
    }

    @Test
    void testExecuteWatchdogAsync() throws Exception {
        long timeout = 10000L;
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.setWorkingDirectory(new File("."));
        executor.setWatchdog(new ExecuteWatchdog(10000L));
        executor.execute(cl, (ExecuteResultHandler)handler);
        handler.waitFor(15000L);
        Assertions.assertTrue((boolean)executor.getWatchdog().killedProcess(), (String)"Killed process should be true");
        Assertions.assertTrue((boolean)handler.hasResult(), (String)"ResultHandler received a result");
        Assertions.assertNotNull((Object)handler.getException(), (String)"ResultHandler received an exception as result");
        int nrOfInvocations = this.getOccurrences(this.readFile(this.foreverOutputFile), '.');
        Assertions.assertTrue((nrOfInvocations > 5 && nrOfInvocations <= 11 ? 1 : 0) != 0, () -> "Killing the process did not work : " + nrOfInvocations);
    }

    @Test
    void testExecuteWatchdogSync() throws Exception {
        if (OS.isFamilyOpenVms()) {
            System.out.println("The test 'testExecuteWatchdogSync' currently hangs on the following OS : " + SystemProperties.getOsName());
            return;
        }
        long timeout = 10000L;
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.setWorkingDirectory(new File("."));
        ExecuteWatchdog watchdog = new ExecuteWatchdog(10000L);
        executor.setWatchdog(watchdog);
        try {
            executor.execute(cl);
        }
        catch (ExecuteException e) {
            Thread.sleep(10000L);
            int nrOfInvocations = this.getOccurrences(this.readFile(this.foreverOutputFile), '.');
            Assertions.assertTrue((boolean)executor.getWatchdog().killedProcess());
            Assertions.assertTrue((nrOfInvocations > 5 && nrOfInvocations <= 11 ? 1 : 0) != 0, () -> "killing the subprocess did not work : " + nrOfInvocations);
            return;
        }
        catch (Throwable t) {
            Assertions.fail((String)t.getMessage());
        }
        Assertions.assertTrue((boolean)executor.getWatchdog().killedProcess(), (String)"Killed process should be true");
        Assertions.fail((String)"Process did not create ExecuteException when killed");
    }

    @Test
    void testExecuteWatchdogVeryLongTimeout() throws Exception {
        long timeout = Long.MAX_VALUE;
        CommandLine cl = new CommandLine(this.testScript);
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.setWorkingDirectory(new File("."));
        ExecuteWatchdog watchdog = new ExecuteWatchdog(Long.MAX_VALUE);
        executor.setWatchdog(watchdog);
        try {
            executor.execute(cl);
        }
        catch (ExecuteException e) {
            Assertions.assertFalse((boolean)watchdog.killedProcess(), (String)"Process should exit normally, not be killed by watchdog");
            throw e;
        }
    }

    @Test
    void testExecuteWithArg() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        cl.addArgument("BAR");
        int exitValue = this.exec.execute(cl);
        Assertions.assertEquals((Object)"FOO..BAR", (Object)this.baos.toString().trim());
        Assertions.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    @Test
    void testExecuteWithComplexArguments() throws Exception {
        CommandLine cl = new CommandLine(this.printArgsScript);
        cl.addArgument("gdal_translate");
        cl.addArgument("HDF5:\"/home/kk/grass/data/4404.he5\"://HDFEOS/GRIDS/OMI_Column_Amount_O3/Data_Fields/ColumnAmountO3/home/kk/4.tif", false);
        DefaultExecutor executor = DefaultExecutor.builder().get();
        int exitValue = executor.execute(cl);
        Assertions.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    @Test
    void testExecuteWithCustomExitValue1() throws Exception {
        this.exec.setExitValue(errorStatus);
        CommandLine cl = new CommandLine(this.errorTestScript);
        this.exec.execute(cl);
    }

    @Test
    void testExecuteWithCustomExitValue2() throws Exception {
        CommandLine cl = new CommandLine(this.errorTestScript);
        this.exec.setExitValue(successStatus);
        try {
            this.exec.execute(cl);
            Assertions.fail((String)"Must throw ExecuteException");
        }
        catch (ExecuteException e) {
            Assertions.assertTrue((boolean)this.exec.isFailure(e.getExitValue()));
        }
    }

    @Test
    void testExecuteWithError() throws Exception {
        CommandLine cl = new CommandLine(this.errorTestScript);
        try {
            this.exec.execute(cl);
            Assertions.fail((String)"Must throw ExecuteException");
        }
        catch (ExecuteException e) {
            Assertions.assertTrue((boolean)this.exec.isFailure(e.getExitValue()));
        }
    }

    @Test
    void testExecuteWithFancyArg() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        cl.addArgument("test $;`(0)[1]{2}");
        int exitValue = this.exec.execute(cl);
        Assertions.assertTrue((this.baos.toString().trim().indexOf("test $;`(0)[1]{2}") > 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    @Test
    void testExecuteWithInvalidWorkingDirectory() throws Exception {
        File workingDir = new File("/foo/bar");
        CommandLine cl = new CommandLine(this.testScript);
        this.exec.setWorkingDirectory(workingDir);
        Assertions.assertThrows(IOException.class, () -> this.exec.execute(cl));
    }

    @Test
    void testExecuteWithNullOutErr() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler(null, null);
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        int exitValue = executor.execute(cl);
        Assertions.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    @Test
    void testExecuteWithProcessDestroyer() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        ShutdownHookProcessDestroyer processDestroyer = new ShutdownHookProcessDestroyer();
        this.exec.setProcessDestroyer((ProcessDestroyer)processDestroyer);
        Assertions.assertTrue((boolean)processDestroyer.isEmpty());
        Assertions.assertFalse((boolean)processDestroyer.isAddedAsShutdownHook());
        int exitValue = this.exec.execute(cl);
        Assertions.assertEquals((Object)"FOO..", (Object)this.baos.toString().trim());
        Assertions.assertFalse((boolean)this.exec.isFailure(exitValue));
        Assertions.assertTrue((boolean)processDestroyer.isEmpty());
        Assertions.assertFalse((boolean)processDestroyer.isAddedAsShutdownHook());
    }

    @Test
    @DisabledOnOs(value={org.junit.jupiter.api.condition.OS.WINDOWS})
    void testExecuteWithRedirectedStreams() throws Exception {
        int exitValue;
        try (FileInputStream fis = new FileInputStream("./NOTICE.txt");){
            CommandLine cl = new CommandLine(this.redirectScript);
            PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)this.baos, (OutputStream)this.baos, (InputStream)fis);
            DefaultExecutor executor = DefaultExecutor.builder().get();
            executor.setWorkingDirectory(new File("."));
            executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
            exitValue = executor.execute(cl);
        }
        String result = this.baos.toString().trim();
        Assertions.assertTrue((result.indexOf("Finished reading from stdin") > 0 ? 1 : 0) != 0, (String)result);
        Assertions.assertFalse((boolean)this.exec.isFailure(exitValue), () -> "exitValue=" + exitValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testExecuteWithRedirectOutErr() throws Exception {
        Path outFile = Files.createTempFile("EXEC", ".test", new FileAttribute[0]);
        CommandLine cl = new CommandLine(this.testScript);
        try (OutputStream outAndErr = Files.newOutputStream(outFile, new OpenOption[0]);){
            PumpStreamHandler pumpStreamHandler = new PumpStreamHandler(outAndErr);
            DefaultExecutor executor = DefaultExecutor.builder().get();
            executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
            int exitValue = executor.execute(cl);
            Assertions.assertFalse((boolean)this.exec.isFailure(exitValue));
            Assertions.assertTrue((boolean)Files.exists(outFile, new LinkOption[0]));
        }
        finally {
            Files.delete(outFile);
        }
    }

    @Test
    void testExecuteWithSingleEnvironmentVariable() throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("TEST_ENV_VAR", "XYZ");
        CommandLine cl = new CommandLine(this.testScript);
        int exitValue = this.exec.execute(cl, env);
        Assertions.assertEquals((Object)"FOO.XYZ.", (Object)this.baos.toString().trim());
        Assertions.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    @Test
    void testExecuteWithStdOutErr() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err);
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        int exitValue = executor.execute(cl);
        Assertions.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    @Test
    void testExecuteWithWorkingDirectory() throws Exception {
        Path workingDirPath = Paths.get("./target", new String[0]);
        CommandLine cl = new CommandLine(this.testScript);
        File workingDirFile = workingDirPath.toFile();
        this.exec.setWorkingDirectory(workingDirFile);
        int exitValue = this.exec.execute(cl);
        Assertions.assertEquals((Object)"FOO..", (Object)this.baos.toString().trim());
        Assertions.assertFalse((boolean)this.exec.isFailure(exitValue));
        Assertions.assertEquals((Object)this.exec.getWorkingDirectory(), (Object)workingDirFile);
        Assertions.assertEquals((Object)this.exec.getWorkingDirectoryPath(), (Object)workingDirPath);
    }

    @Test
    void testStdInHandling() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream("Foo".getBytes());
        CommandLine cl = new CommandLine(this.stdinSript);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)this.baos, (OutputStream)System.err, (InputStream)bais);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        executor.execute(cl, (ExecuteResultHandler)resultHandler);
        resultHandler.waitFor(15000L);
        Assertions.assertTrue((boolean)resultHandler.hasResult(), (String)"ResultHandler received a result");
        Assertions.assertFalse((boolean)this.exec.isFailure(resultHandler.getExitValue()));
        String result = this.baos.toString();
        Assertions.assertTrue((boolean)result.contains("Hello Foo!"), (String)("Result '" + result + "' should contain 'Hello Foo!'"));
    }
}

