/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.DirectoryFileFilter;
import org.apache.commons.vfs2.filter.FileFileFilter;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class DirectoryAndFileFilterTest
extends BaseFilterTest {
    private static final String FILE = "myfile.txt";
    private static final String DIR = "mydir";
    private static File testDir;
    private static File file;
    private static FileSelectInfo fileInfo;
    private static File dir;
    private static FileSelectInfo dirInfo;
    private static File notExistingFile;
    private static FileSelectInfo notExistingFileInfo;
    private static File zipFile;
    private static FileObject zipFileObj;

    @AfterAll
    public static void afterClass() throws IOException {
        file = null;
        fileInfo = null;
        dir = null;
        dirInfo = null;
        notExistingFileInfo = null;
        notExistingFile = null;
        IOUtils.close((Closeable)zipFileObj);
        FileUtils.deleteQuietly((File)zipFile);
        zipFile = null;
        FileUtils.deleteDirectory((File)testDir);
        testDir = null;
    }

    @BeforeAll
    public static void beforeClass() throws IOException {
        testDir = DirectoryAndFileFilterTest.getTestDir(DirectoryAndFileFilterTest.class.getName());
        testDir.mkdir();
        dir = new File(testDir, DIR);
        dir.mkdir();
        dirInfo = DirectoryAndFileFilterTest.createFileSelectInfo(dir);
        file = new File(dir, FILE);
        FileUtils.touch((File)file);
        fileInfo = DirectoryAndFileFilterTest.createFileSelectInfo(file);
        notExistingFile = new File(testDir, "not-existing-file.txt");
        notExistingFileInfo = DirectoryAndFileFilterTest.createFileSelectInfo(notExistingFile);
        zipFile = new File(DirectoryAndFileFilterTest.getTempDir(), DirectoryAndFileFilterTest.class.getName() + ".zip");
        DirectoryAndFileFilterTest.zipDir(testDir, "", zipFile);
        zipFileObj = DirectoryAndFileFilterTest.getZipFileObject(zipFile);
    }

    @Test
    public void testAcceptZipFile() throws FileSystemException {
        FileObject[] files = zipFileObj.findFiles(new FileSelector(){

            public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
                return FileFileFilter.FILE.accept(fileInfo);
            }

            public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
                return true;
            }
        });
        this.assertContains(files, FILE);
        Assertions.assertEquals((int)1, (int)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector(DirectoryFileFilter.DIRECTORY));
        this.assertContains(files, DIR);
        Assertions.assertEquals((int)1, (int)files.length);
    }

    @Test
    public void testDirectoryFileFilter() throws FileSystemException {
        FileFilter testee = DirectoryFileFilter.DIRECTORY;
        Assertions.assertTrue((boolean)testee.accept(dirInfo));
        Assertions.assertFalse((boolean)testee.accept(fileInfo));
        Assertions.assertFalse((boolean)testee.accept(notExistingFileInfo));
    }

    @Test
    public void testFileFileFilter() throws FileSystemException {
        FileFilter testee = FileFileFilter.FILE;
        Assertions.assertTrue((boolean)testee.accept(fileInfo));
        Assertions.assertFalse((boolean)testee.accept(dirInfo));
        Assertions.assertFalse((boolean)testee.accept(notExistingFileInfo));
    }
}

