/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import org.apache.daffodil.lib.schema.annotation.props.gen.LengthKind;
import org.apache.daffodil.lib.schema.annotation.props.gen.LengthKind$Implicit$;
import org.apache.daffodil.lib.schema.annotation.props.gen.LengthUnits;
import org.apache.daffodil.lib.util.Numbers$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.parsers.BinaryBooleanParserBase;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public class BinaryBooleanParser
extends BinaryBooleanParserBase {
    private final ElementRuntimeData context;
    private final Evaluatable<Long> lengthEv;
    private final LengthKind lengthKind;

    public BinaryBooleanParser(ElementRuntimeData context, long binaryBooleanTrueRep, long binaryBooleanFalseRep, Evaluatable<Long> lengthEv, LengthUnits lengthUnits, LengthKind lengthKind) {
        this.context = context;
        this.lengthEv = lengthEv;
        this.lengthKind = lengthKind;
        super(binaryBooleanTrueRep, binaryBooleanFalseRep, lengthUnits);
    }

    @Override
    public ElementRuntimeData context() {
        return this.context;
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Evaluatable[]{this.lengthEv}));
    }

    @Override
    public int getBitLength(PState state) {
        Long nBytesAsJLong = this.lengthEv.evaluate(state);
        Integer nBytes = Numbers$.MODULE$.asInt(nBytesAsJLong);
        LengthKind lengthKind = this.lengthKind;
        if (LengthKind$Implicit$.MODULE$.equals(lengthKind)) {
            return Predef$.MODULE$.Integer2int(nBytes);
        }
        return Predef$.MODULE$.Integer2int(nBytes) * this.toBits();
    }
}

