/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.utils.URIUtils;

public class Resource {
    private final InputStream stream;
    private final URI uri;
    private final URI localURI;
    private final String contentType;

    public Resource(InputStream stream, URI uri, URI localURI) {
        this.stream = stream;
        this.uri = uri;
        this.localURI = localURI;
        this.contentType = null;
    }

    public Resource(InputStream stream, URI uri, URI localURI, String contentType) {
        this.stream = stream;
        this.uri = uri;
        this.localURI = localURI;
        this.contentType = contentType;
    }

    public Resource(String href) throws IOException, URISyntaxException {
        this(null, href);
    }

    public Resource(ResolverConfiguration config, String href) throws IOException, URISyntaxException {
        if (href.startsWith("data:")) {
            this.localURI = this.uri = URIUtils.newURI(href);
            String path = href.substring(5);
            int pos = path.indexOf(",");
            if (pos >= 0) {
                String mediatype = path.substring(0, pos);
                String data = path.substring(pos + 1);
                if (mediatype.endsWith(";base64")) {
                    this.stream = new ByteArrayInputStream(Base64.getDecoder().decode(data));
                    this.contentType = mediatype.substring(0, mediatype.length() - 7);
                } else {
                    String charset = "UTF-8";
                    pos = mediatype.indexOf(";charset=");
                    if (pos > 0 && (pos = (charset = mediatype.substring(pos + 9)).indexOf(";")) >= 0) {
                        charset = charset.substring(0, pos);
                    }
                    data = URLDecoder.decode(data, charset);
                    this.stream = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
                    this.contentType = "".equals(mediatype) ? null : mediatype;
                }
                return;
            }
            throw new URISyntaxException(href, "Comma separator missing");
        }
        if (href.startsWith("classpath:")) {
            ClassLoader loader;
            URL rsrc;
            String path = href.substring(10);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((rsrc = (loader = config == null ? this.getClass().getClassLoader() : config.getFeature(ResolverFeature.CLASSLOADER)).getResource(path)) == null) {
                throw new IOException("Not found: " + href);
            }
            this.localURI = this.uri = URIUtils.newURI(rsrc.toString());
            this.stream = rsrc.openStream();
            this.contentType = null;
            return;
        }
        this.localURI = this.uri = URIUtils.newURI(href);
        URLConnection conn = this.uri.toURL().openConnection();
        this.stream = conn.getInputStream();
        this.contentType = conn.getContentType();
    }

    public Resource(URI href) throws IOException, URISyntaxException {
        this(null, href);
    }

    public Resource(ResolverConfiguration config, URI href) throws IOException, URISyntaxException {
        if ("data".equals(href.getScheme())) {
            this.localURI = this.uri = href;
            String path = href.getSchemeSpecificPart();
            int pos = path.indexOf(",");
            if (pos >= 0) {
                String mediatype = path.substring(0, pos);
                String data = path.substring(pos + 1);
                if (mediatype.endsWith(";base64")) {
                    this.stream = new ByteArrayInputStream(Base64.getDecoder().decode(data));
                    this.contentType = mediatype.substring(0, mediatype.length() - 7);
                } else {
                    String charset = "UTF-8";
                    pos = mediatype.indexOf(";charset=");
                    if (pos > 0 && (pos = (charset = mediatype.substring(pos + 9)).indexOf(";")) >= 0) {
                        charset = charset.substring(0, pos);
                    }
                    data = URLDecoder.decode(data, charset);
                    this.stream = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
                    this.contentType = "".equals(mediatype) ? null : mediatype;
                }
                return;
            }
            throw new URISyntaxException(href.toString(), "Comma separator missing");
        }
        if ("classpath".equals(href.getScheme())) {
            ClassLoader loader;
            URL rsrc;
            String path = href.getSchemeSpecificPart();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((rsrc = (loader = config == null ? this.getClass().getClassLoader() : config.getFeature(ResolverFeature.CLASSLOADER)).getResource(path)) == null) {
                throw new IOException("Not found: " + href);
            }
            this.localURI = this.uri = URIUtils.newURI(rsrc.toString());
            this.stream = rsrc.openStream();
            this.contentType = null;
            return;
        }
        this.localURI = this.uri = href;
        URLConnection conn = this.uri.toURL().openConnection();
        this.stream = conn.getInputStream();
        this.contentType = conn.getContentType();
    }

    public InputStream body() {
        return this.stream;
    }

    public URI uri() {
        return this.uri;
    }

    public URI localUri() {
        return this.localURI;
    }

    public String contentType() {
        return this.contentType;
    }
}

