/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.spi.entitymanager;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.persistence.EntityManager;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.deltaspike.jpa.api.entitymanager.EntityManagerResolver;

public class QualifierBackedEntityManagerResolver
implements EntityManagerResolver {
    private static final Logger logger = Logger.getLogger(QualifierBackedEntityManagerResolver.class.getName());
    private final Class<? extends Annotation>[] qualifiers;
    private final BeanManager beanManager;

    public QualifierBackedEntityManagerResolver(BeanManager beanManager, Class<? extends Annotation> ... qualifiers) {
        this.beanManager = beanManager;
        this.qualifiers = qualifiers;
    }

    @Override
    public EntityManager resolveEntityManager() {
        Bean<EntityManager> entityManagerBean = this.resolveEntityManagerBeans();
        if (entityManagerBean == null) {
            StringBuilder qualifierNames = new StringBuilder();
            for (Class<? extends Annotation> c : this.qualifiers) {
                qualifierNames.append(c.getName()).append(" ");
            }
            throw new IllegalStateException("Cannot find an EntityManager qualified with [" + qualifierNames + "]. Did you add a corresponding producer?");
        }
        return (EntityManager)this.beanManager.getReference(entityManagerBean, EntityManager.class, this.beanManager.createCreationalContext(entityManagerBean));
    }

    private Bean<EntityManager> resolveEntityManagerBeans() {
        HashSet entityManagerBeans = this.beanManager.getBeans(EntityManager.class, new Annotation[]{Any.Literal.INSTANCE});
        if (entityManagerBeans == null) {
            entityManagerBeans = new HashSet();
        }
        HashSet<Bean> detectedEntityManagerBeans = new HashSet<Bean>();
        for (Class<? extends Annotation> qualifierClass : this.qualifiers) {
            for (Bean currentEntityManagerBean : entityManagerBeans) {
                Set foundQualifierAnnotations = currentEntityManagerBean.getQualifiers();
                for (Annotation currentQualifierAnnotation : foundQualifierAnnotations) {
                    if (!currentQualifierAnnotation.annotationType().equals(qualifierClass)) continue;
                    detectedEntityManagerBeans.add(currentEntityManagerBean);
                }
            }
        }
        if (detectedEntityManagerBeans.size() > 1) {
            logger.warning("detected multiple entityManager provider: " + detectedEntityManagerBeans);
        }
        if (!detectedEntityManagerBeans.isEmpty()) {
            Bean entityManagerBean = (Bean)detectedEntityManagerBeans.iterator().next();
            logger.fine("detected entityManager provider: " + entityManagerBean);
            return entityManagerBean;
        }
        return null;
    }
}

