/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.io.Closeable;
import java.io.IOException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.join.NullAwareJoinHelper;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.util.MutableObjectIterator;

public class SortMergeFullOuterJoinIterator
implements Closeable {
    private final Projection<RowData, BinaryRowData> projection1;
    private final Projection<RowData, BinaryRowData> projection2;
    private final RecordComparator keyComparator;
    private final MutableObjectIterator<BinaryRowData> iterator1;
    private final MutableObjectIterator<BinaryRowData> iterator2;
    private BinaryRowData row1;
    private BinaryRowData key1;
    private BinaryRowData row2;
    private BinaryRowData key2;
    private BinaryRowData matchKey;
    private ResettableExternalBuffer buffer1;
    private ResettableExternalBuffer buffer2;
    private final int[] nullFilterKeys;
    private final boolean nullSafe;
    private final boolean filterAllNulls;

    public SortMergeFullOuterJoinIterator(BinaryRowDataSerializer serializer1, BinaryRowDataSerializer serializer2, Projection<RowData, BinaryRowData> projection1, Projection<RowData, BinaryRowData> projection2, RecordComparator keyComparator, MutableObjectIterator<BinaryRowData> iterator1, MutableObjectIterator<BinaryRowData> iterator2, ResettableExternalBuffer buffer1, ResettableExternalBuffer buffer2, boolean[] filterNulls) throws IOException {
        this.projection1 = projection1;
        this.projection2 = projection2;
        this.keyComparator = keyComparator;
        this.iterator1 = iterator1;
        this.iterator2 = iterator2;
        this.row1 = serializer1.createInstance();
        this.row2 = serializer2.createInstance();
        this.buffer1 = buffer1;
        this.buffer2 = buffer2;
        this.nullFilterKeys = NullAwareJoinHelper.getNullFilterKeys(filterNulls);
        this.nullSafe = this.nullFilterKeys.length == 0;
        this.filterAllNulls = this.nullFilterKeys.length == filterNulls.length;
        this.nextRow1();
        this.nextRow2();
    }

    private boolean shouldFilter(BinaryRowData key) {
        return NullAwareJoinHelper.shouldFilter(this.nullSafe, this.filterAllNulls, this.nullFilterKeys, key);
    }

    public boolean nextOuterJoin() throws IOException {
        if (this.key1 != null && (this.shouldFilter(this.key1) || this.key2 == null)) {
            this.matchKey = null;
            this.bufferRows1();
            this.buffer2.reset();
            this.buffer2.complete();
            return true;
        }
        if (this.key2 != null && (this.shouldFilter(this.key2) || this.key1 == null)) {
            this.matchKey = null;
            this.buffer1.reset();
            this.buffer1.complete();
            this.bufferRows2();
            return true;
        }
        if (this.key1 != null && this.key2 != null) {
            int cmp = this.keyComparator.compare((RowData)this.key1, (RowData)this.key2);
            if (cmp == 0) {
                this.matchKey = this.key1;
                this.bufferRows1();
                this.bufferRows2();
            } else if (cmp > 0) {
                this.matchKey = null;
                this.buffer1.reset();
                this.buffer1.complete();
                this.bufferRows2();
            } else {
                this.matchKey = null;
                this.buffer2.reset();
                this.buffer2.complete();
                this.bufferRows1();
            }
            return true;
        }
        return false;
    }

    private void bufferRows1() throws IOException {
        BinaryRowData copy = this.key1.copy();
        this.buffer1.reset();
        do {
            this.buffer1.add((RowData)this.row1);
        } while (this.nextRow1() && this.keyComparator.compare((RowData)this.key1, (RowData)copy) == 0);
        this.buffer1.complete();
    }

    private void bufferRows2() throws IOException {
        BinaryRowData copy = this.key2.copy();
        this.buffer2.reset();
        do {
            this.buffer2.add((RowData)this.row2);
        } while (this.nextRow2() && this.keyComparator.compare((RowData)this.key2, (RowData)copy) == 0);
        this.buffer2.complete();
    }

    private boolean nextRow1() throws IOException {
        this.row1 = (BinaryRowData)this.iterator1.next((Object)this.row1);
        if (this.row1 != null) {
            this.key1 = this.projection1.apply((RowData)this.row1);
            return true;
        }
        this.row1 = null;
        this.key1 = null;
        return false;
    }

    private boolean nextRow2() throws IOException {
        this.row2 = (BinaryRowData)this.iterator2.next((Object)this.row2);
        if (this.row2 != null) {
            this.key2 = this.projection2.apply((RowData)this.row2);
            return true;
        }
        this.row2 = null;
        this.key2 = null;
        return false;
    }

    public BinaryRowData getMatchKey() {
        return this.matchKey;
    }

    public ResettableExternalBuffer getBuffer1() {
        return this.buffer1;
    }

    public ResettableExternalBuffer getBuffer2() {
        return this.buffer2;
    }

    @Override
    public void close() {
        this.buffer1.close();
        this.buffer2.close();
    }
}

