/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.support;

import jakarta.persistence.FlushModeType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreUtils;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractDatastorePersistenceContextInterceptor {
    private static final Log LOG = LogFactory.getLog(AbstractDatastorePersistenceContextInterceptor.class);
    protected Datastore datastore;

    public AbstractDatastorePersistenceContextInterceptor(Datastore datastore) {
        this.datastore = datastore;
    }

    public void init() {
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(this.datastore);
        if (sessionHolder == null) {
            LOG.debug("Opening single Datastore session in DatastorePersistenceContextInterceptor");
            Session session = this.getSession();
            session.setFlushMode(FlushModeType.AUTO);
            try {
                DatastoreUtils.bindSession(session, this);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    protected Session getSession() {
        return DatastoreUtils.getSession(this.datastore, true);
    }

    public void destroy() {
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(this.datastore);
        if (sessionHolder != null && this == sessionHolder.getCreator()) {
            SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.unbindResource(this.datastore);
            LOG.debug("Closing single Datastore session in DatastorePersistenceContextInterceptor");
            try {
                Session session = holder.getSession();
                DatastoreUtils.closeSession(session);
            }
            catch (RuntimeException ex) {
                LOG.error("Unexpected exception on closing Datastore Session", ex);
            }
        }
    }

    public void disconnect() {
        this.destroy();
    }

    public void reconnect() {
        this.init();
    }

    public void flush() {
        Session session = this.getSession();
        if (session.hasTransaction()) {
            session.flush();
        }
    }

    public void clear() {
        this.getSession().clear();
    }

    public void setReadOnly() {
        this.getSession().setFlushMode(FlushModeType.COMMIT);
    }

    public void setReadWrite() {
        this.getSession().setFlushMode(FlushModeType.AUTO);
    }

    public boolean isOpen() {
        try {
            return DatastoreUtils.doGetSession(this.datastore, false).isConnected();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }
}

