/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model;

import groovy.lang.MetaProperty;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.grails.datastore.mapping.config.Entity;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.model.ValueGenerator;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.Custom;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.model.types.Identity;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.ManyToOne;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.model.types.OneToOne;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.model.types.TenantId;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;

public abstract class MappingFactory<R extends Entity, T extends Property> {
    public static final String IDENTITY_PROPERTY = "id";
    public static final Set<String> SIMPLE_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Boolean.TYPE.getName(), Long.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Byte.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Character.TYPE.getName(), Boolean.class.getName(), Long.class.getName(), Short.class.getName(), Integer.class.getName(), Byte.class.getName(), Float.class.getName(), Double.class.getName(), Character.class.getName(), String.class.getName(), java.util.Date.class.getName(), Time.class.getName(), Timestamp.class.getName(), Date.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName(), Locale.class.getName(), Calendar.class.getName(), GregorianCalendar.class.getName(), Currency.class.getName(), TimeZone.class.getName(), Object.class.getName(), Class.class.getName(), byte[].class.getName(), Byte[].class.getName(), char[].class.getName(), Character[].class.getName(), Blob.class.getName(), Clob.class.getName(), Serializable.class.getName(), URI.class.getName(), URL.class.getName(), UUID.class.getName(), "org.bson.types.ObjectId", "java.time.Instant", "java.time.LocalDateTime", "java.time.LocalDate", "java.time.LocalTime", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.ZonedDateTime")));
    private Map<Class, Collection<CustomTypeMarshaller>> typeConverterMap = new ConcurrentHashMap<Class, Collection<CustomTypeMarshaller>>();

    public void registerCustomType(CustomTypeMarshaller marshallerCustom) {
        Collection<CustomTypeMarshaller> marshallers = this.typeConverterMap.get(marshallerCustom.getTargetType());
        if (marshallers == null) {
            marshallers = new ConcurrentLinkedQueue<CustomTypeMarshaller>();
            this.typeConverterMap.put(marshallerCustom.getTargetType(), marshallers);
        }
        marshallers.add(marshallerCustom);
    }

    public boolean isSimpleType(Class propType) {
        if (propType == null) {
            return false;
        }
        if (propType.isEnum()) {
            return !this.isCustomType(propType);
        }
        if (propType.isArray()) {
            return this.isSimpleType(propType.getComponentType());
        }
        String typeName = propType.getName();
        return MappingFactory.isSimpleType(typeName);
    }

    public static boolean isSimpleType(String typeName) {
        return SIMPLE_TYPES.contains(typeName);
    }

    public abstract R createMappedForm(PersistentEntity var1);

    public abstract T createMappedForm(PersistentProperty var1);

    public Identity<T> createIdentity(PersistentEntity owner, MappingContext context, PropertyDescriptor pd) {
        return new Identity<T>(owner, context, pd){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            @Override
            public PropertyMapping<T> getMapping() {
                return this.propertyMapping;
            }
        };
    }

    public TenantId<T> createTenantId(PersistentEntity owner, MappingContext context, PropertyDescriptor pd) {
        return new TenantId<T>(owner, context, pd){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createDerivedPropertyMapping(this, this.owner);
            }

            @Override
            public PropertyMapping<T> getMapping() {
                return this.propertyMapping;
            }
        };
    }

    public abstract boolean isTenantId(PersistentEntity var1, MappingContext var2, PropertyDescriptor var3);

    public Custom<T> createCustom(PersistentEntity owner, MappingContext context, PropertyDescriptor pd) {
        Class<?> propertyType = pd.getPropertyType();
        CustomTypeMarshaller customTypeMarshaller = this.findCustomType(context, propertyType);
        if (customTypeMarshaller == null && propertyType.isEnum()) {
            customTypeMarshaller = this.findCustomType(context, Enum.class);
        }
        if (customTypeMarshaller == null && !this.allowArbitraryCustomTypes()) {
            throw new IllegalStateException("Cannot create a custom type without a type converter for type " + String.valueOf(propertyType));
        }
        return new Custom<T>(owner, context, pd, customTypeMarshaller){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            @Override
            public PropertyMapping<T> getMapping() {
                return this.propertyMapping;
            }
        };
    }

    protected boolean allowArbitraryCustomTypes() {
        return false;
    }

    protected CustomTypeMarshaller findCustomType(MappingContext context, Class<?> propertyType) {
        Collection<CustomTypeMarshaller> allMarshallers = this.typeConverterMap.get(propertyType);
        if (allMarshallers != null) {
            for (CustomTypeMarshaller marshaller : allMarshallers) {
                if (!marshaller.supports(context)) continue;
                return marshaller;
            }
        }
        return null;
    }

    public PropertyDescriptor createPropertyDescriptor(Class declaringClass, MetaProperty property) {
        return ClassPropertyFetcher.createPropertyDescriptor(declaringClass, property);
    }

    public Simple<T> createSimple(PersistentEntity owner, MappingContext context, PropertyDescriptor pd) {
        return new Simple<T>(owner, context, pd){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            @Override
            public PropertyMapping<T> getMapping() {
                return this.propertyMapping;
            }
        };
    }

    protected PropertyMapping<T> createPropertyMapping(final PersistentProperty<T> property, final PersistentEntity owner) {
        return new PropertyMapping<T>(){
            private T mappedForm;
            {
                this.mappedForm = MappingFactory.this.createMappedForm(property);
            }

            @Override
            public ClassMapping getClassMapping() {
                return owner.getMapping();
            }

            @Override
            public T getMappedForm() {
                return this.mappedForm;
            }
        };
    }

    private PropertyMapping<T> createDerivedPropertyMapping(PersistentProperty<T> property, PersistentEntity owner) {
        T mappedFormObject = this.createMappedForm(property);
        ((Property)mappedFormObject).setDerived(true);
        return new PropertyMapping<T>((Property)mappedFormObject, owner){
            private T mappedForm;
            final /* synthetic */ Property val$mappedFormObject;
            final /* synthetic */ PersistentEntity val$owner;
            {
                this.val$mappedFormObject = property;
                this.val$owner = persistentEntity;
                this.mappedForm = this.val$mappedFormObject;
            }

            @Override
            public ClassMapping getClassMapping() {
                return this.val$owner.getMapping();
            }

            @Override
            public T getMappedForm() {
                return this.mappedForm;
            }
        };
    }

    public ToOne createOneToOne(PersistentEntity entity, MappingContext context, PropertyDescriptor property) {
        return new OneToOne<T>(entity, context, property){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            @Override
            public PropertyMapping getMapping() {
                return this.propertyMapping;
            }

            @Override
            public String toString() {
                return MappingFactory.associationtoString("one-to-one: ", this);
            }
        };
    }

    public ToOne createManyToOne(PersistentEntity entity, MappingContext context, PropertyDescriptor property) {
        return new ManyToOne<T>(entity, context, property){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            @Override
            public PropertyMapping getMapping() {
                return this.propertyMapping;
            }

            @Override
            public String toString() {
                return MappingFactory.associationtoString("many-to-one: ", this);
            }
        };
    }

    public OneToMany createOneToMany(PersistentEntity entity, MappingContext context, PropertyDescriptor property) {
        return new OneToMany<T>(entity, context, property){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            @Override
            public PropertyMapping getMapping() {
                return this.propertyMapping;
            }

            @Override
            public String toString() {
                return MappingFactory.associationtoString("one-to-many: ", this);
            }
        };
    }

    public ManyToMany createManyToMany(PersistentEntity entity, MappingContext context, PropertyDescriptor property) {
        return new ManyToMany<T>(entity, context, property){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            @Override
            public PropertyMapping getMapping() {
                return this.propertyMapping;
            }

            @Override
            public String toString() {
                return MappingFactory.associationtoString("many-to-many: ", this);
            }
        };
    }

    public Embedded createEmbedded(PersistentEntity entity, MappingContext context, PropertyDescriptor property) {
        return new Embedded<T>(entity, context, property){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            @Override
            public PropertyMapping getMapping() {
                return this.propertyMapping;
            }

            @Override
            public String toString() {
                return MappingFactory.associationtoString("embedded: ", this);
            }
        };
    }

    public EmbeddedCollection createEmbeddedCollection(PersistentEntity entity, MappingContext context, PropertyDescriptor property) {
        return new EmbeddedCollection<T>(entity, context, property){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            @Override
            public PropertyMapping getMapping() {
                return this.propertyMapping;
            }

            @Override
            public String toString() {
                return MappingFactory.associationtoString("embedded: ", this);
            }
        };
    }

    public Basic createBasicCollection(PersistentEntity entity, MappingContext context, PropertyDescriptor property, Class collectionType) {
        Basic basic = new Basic(entity, context, property){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            @Override
            public PropertyMapping getMapping() {
                return this.propertyMapping;
            }
        };
        CustomTypeMarshaller customTypeMarshaller = this.findCustomType(context, property.getPropertyType());
        if (collectionType != null && collectionType.isEnum() && (customTypeMarshaller = this.findCustomType(context, collectionType)) == null) {
            customTypeMarshaller = this.findCustomType(context, Enum.class);
        }
        if (customTypeMarshaller != null) {
            basic.setCustomTypeMarshaller(customTypeMarshaller);
        }
        return basic;
    }

    public Basic createBasicCollection(PersistentEntity entity, MappingContext context, PropertyDescriptor property) {
        return this.createBasicCollection(entity, context, property, null);
    }

    public boolean isCustomType(Class<?> propertyType) {
        if (this.typeConverterMap.containsKey(propertyType)) {
            return true;
        }
        if (propertyType.isEnum()) {
            return this.typeConverterMap.containsKey(Enum.class);
        }
        return false;
    }

    public IdentityMapping createIdentityMapping(ClassMapping classMapping) {
        return this.createDefaultIdentityMapping(classMapping);
    }

    public IdentityMapping createDefaultIdentityMapping(final ClassMapping classMapping) {
        return new IdentityMapping(){

            @Override
            public String[] getIdentifierName() {
                String propertyName;
                PersistentProperty identity = classMapping.getEntity().getIdentity();
                String string = propertyName = identity != null ? ((Property)identity.getMapping().getMappedForm()).getName() : null;
                if (propertyName != null) {
                    return new String[]{propertyName};
                }
                return new String[]{MappingFactory.IDENTITY_PROPERTY};
            }

            @Override
            public ValueGenerator getGenerator() {
                return ValueGenerator.AUTO;
            }

            @Override
            public ClassMapping getClassMapping() {
                return classMapping;
            }

            public Property getMappedForm() {
                return classMapping.getEntity().getIdentity().getMapping().getMappedForm();
            }
        };
    }

    protected IdentityMapping createDefaultIdentityMapping(final ClassMapping classMapping, T property) {
        final String targetName = property != null ? ((Property)property).getName() : null;
        final String generator = property != null ? ((Property)property).getGenerator() : null;
        return new IdentityMapping(){
            final /* synthetic */ Property val$property;
            {
                this.val$property = property;
            }

            @Override
            public String[] getIdentifierName() {
                if (targetName != null) {
                    return new String[]{targetName};
                }
                return new String[]{MappingFactory.IDENTITY_PROPERTY};
            }

            @Override
            public ValueGenerator getGenerator() {
                return generator != null ? ValueGenerator.valueOf(generator) : ValueGenerator.AUTO;
            }

            @Override
            public ClassMapping getClassMapping() {
                return classMapping;
            }

            public Property getMappedForm() {
                return this.val$property;
            }
        };
    }

    public static String associationtoString(String desc, Association a) {
        return desc + a.getOwner().getName() + "-> " + a.getName() + " ->" + a.getAssociatedEntity().getName();
    }
}

