/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.JdbcConnectionDetails;
import org.springframework.boot.autoconfigure.jdbc.PropertiesJdbcConnectionDetails;
import org.springframework.core.PriorityOrdered;

abstract class JdbcConnectionDetailsBeanPostProcessor<T>
implements BeanPostProcessor,
PriorityOrdered {
    private final Class<T> dataSourceClass;
    private final ObjectProvider<JdbcConnectionDetails> connectionDetailsProvider;

    JdbcConnectionDetailsBeanPostProcessor(Class<T> dataSourceClass, ObjectProvider<JdbcConnectionDetails> connectionDetailsProvider) {
        this.dataSourceClass = dataSourceClass;
        this.connectionDetailsProvider = connectionDetailsProvider;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        JdbcConnectionDetails connectionDetails;
        if (this.dataSourceClass.isAssignableFrom(bean2.getClass()) && "dataSource".equals(beanName) && !((connectionDetails = this.connectionDetailsProvider.getObject()) instanceof PropertiesJdbcConnectionDetails)) {
            return this.processDataSource(bean2, connectionDetails);
        }
        return bean2;
    }

    protected abstract Object processDataSource(T var1, JdbcConnectionDetails var2);

    @Override
    public int getOrder() {
        return -2147483646;
    }
}

