/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.ref.SoftReference;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.ElementHolder;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;

public class ReferenceHolder<E, K, V>
implements ElementHolder<E, K, V> {
    private BTree<K, V> btree;
    private long offset;
    private long lastOffset;
    private SoftReference<E> reference;

    public ReferenceHolder(BTree<K, V> btree, E element, long offset, long lastOffset) {
        this.btree = btree;
        this.offset = offset;
        this.lastOffset = lastOffset;
        this.reference = new SoftReference<E>(element);
    }

    @Override
    public E getValue(BTree<K, V> btree) throws EndOfFileExceededException, IOException {
        E element = this.reference.get();
        if (element == null) {
            element = this.fetchElement(btree);
            this.reference = new SoftReference<E>(element);
        }
        return element;
    }

    private E fetchElement(BTree<K, V> btree) throws EndOfFileExceededException, IOException {
        Page element = btree.getRecordManager().deserialize(btree, this.offset);
        return (E)element;
    }

    long getOffset() {
        return this.offset;
    }

    long getLastOffset() {
        return this.lastOffset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        E element = this.reference.get();
        if (element != null) {
            sb.append(this.btree.getName()).append("[").append(this.offset).append("]:").append(element);
        } else {
            sb.append(this.btree.getName()).append("[").append(this.offset).append("]");
        }
        return sb.toString();
    }
}

