/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.TooSlowLog;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class LogHandlerUtils {
    private static int getTotalFiltersCount(AdminProtos.SlowLogResponseRequest request) {
        int totalFilters = 0;
        if (StringUtils.isNotEmpty(request.getRegionName())) {
            ++totalFilters;
        }
        if (StringUtils.isNotEmpty(request.getTableName())) {
            ++totalFilters;
        }
        if (StringUtils.isNotEmpty(request.getClientAddress())) {
            ++totalFilters;
        }
        if (StringUtils.isNotEmpty(request.getUserName())) {
            ++totalFilters;
        }
        return totalFilters;
    }

    private static List<TooSlowLog.SlowLogPayload> filterLogs(AdminProtos.SlowLogResponseRequest request, List<TooSlowLog.SlowLogPayload> slowLogPayloadList, int totalFilters) {
        ArrayList<TooSlowLog.SlowLogPayload> filteredSlowLogPayloads = new ArrayList<TooSlowLog.SlowLogPayload>();
        String regionName = StringUtils.isNotEmpty(request.getRegionName()) ? request.getRegionName() : null;
        String tableName = StringUtils.isNotEmpty(request.getTableName()) ? request.getTableName() : null;
        String clientAddress = StringUtils.isNotEmpty(request.getClientAddress()) ? request.getClientAddress() : null;
        String userName = StringUtils.isNotEmpty(request.getUserName()) ? request.getUserName() : null;
        for (TooSlowLog.SlowLogPayload slowLogPayload : slowLogPayloadList) {
            int totalFilterMatches = 0;
            if (slowLogPayload.getRegionName().equals(regionName)) {
                ++totalFilterMatches;
            }
            if (tableName != null && slowLogPayload.getRegionName().startsWith(tableName)) {
                ++totalFilterMatches;
            }
            if (LogHandlerUtils.isClientAddressMatched(slowLogPayload, clientAddress)) {
                ++totalFilterMatches;
            }
            if (slowLogPayload.getUserName().equals(userName)) {
                ++totalFilterMatches;
            }
            if (request.hasFilterByOperator() && request.getFilterByOperator().equals(AdminProtos.SlowLogResponseRequest.FilterByOperator.AND)) {
                if (totalFilterMatches != totalFilters) continue;
                filteredSlowLogPayloads.add(slowLogPayload);
                continue;
            }
            if (totalFilterMatches <= 0) continue;
            filteredSlowLogPayloads.add(slowLogPayload);
        }
        return filteredSlowLogPayloads;
    }

    private static boolean isClientAddressMatched(TooSlowLog.SlowLogPayload slowLogPayload, String clientAddress) {
        String clientAddressInPayload = slowLogPayload.getClientAddress();
        int portPos = clientAddressInPayload.lastIndexOf(":");
        if (portPos < 1) {
            return clientAddressInPayload.equals(clientAddress);
        }
        return clientAddressInPayload.equals(clientAddress) || clientAddressInPayload.substring(0, portPos).equals(clientAddress);
    }

    public static List<TooSlowLog.SlowLogPayload> getFilteredLogs(AdminProtos.SlowLogResponseRequest request, List<TooSlowLog.SlowLogPayload> logPayloadList) {
        int totalFilters = LogHandlerUtils.getTotalFiltersCount(request);
        if (totalFilters > 0) {
            logPayloadList = LogHandlerUtils.filterLogs(request, logPayloadList, totalFilters);
        }
        int limit = Math.min(request.getLimit(), logPayloadList.size());
        return logPayloadList.subList(0, limit);
    }
}

