/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.io.Closeable;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Evolving
public interface FailoverProxyProvider<T>
extends Closeable {
    public ProxyInfo<T> getProxy();

    public void performFailover(T var1);

    public Class<T> getInterface();

    public static class ProxyInfo<T> {
        public T proxy;
        public String proxyInfo;

        public ProxyInfo(T proxy, String proxyInfo) {
            this.proxy = proxy;
            this.proxyInfo = proxyInfo;
        }

        private String proxyName() {
            return this.proxy != null ? this.proxy.getClass().getSimpleName() : "UnknownProxy";
        }

        public String getString(String methodName) {
            return this.proxyName() + "." + methodName + " over " + this.proxyInfo;
        }

        public String toString() {
            return this.proxyName() + " over " + this.proxyInfo;
        }
    }
}

