<!--
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

# Code analysis

The `run-coverage.sh` script runs maven with the **jacoco** profile
which generates the test coverage data for the java classes.
If the required parameters are given it also runs the sonar code analysis
and uploads the results to the given SonarQube Server.

## Running code analysis

After running the script the reports generated by the JaCoCo
code coverage library can be found under the `/target/site/jacoco/` folder of
the related modules.

Here is how you can generate the code coverage report:

```sh dev/code-coverage/run-coverage.sh```

## Publishing coverage results to SonarQube

The required parameters for publishing the results to SonarQube are:

- host URL,
- login credentials,
- project key

The project name is an optional parameter.

Here is an example command for running and publishing the coverage data:

`./dev/code-coverage/run-coverage.sh -l ProjectCredentials
-u https://exampleserver.com -k Project_Key -n Project_Name`
