/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.classic;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.MethodNotSupportedException;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.WWWFormCodec;

public class RandomHandler
implements HttpRequestHandler {
    public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException, IOException {
        long n;
        String path;
        int slash;
        URI uri;
        String method = request.getMethod();
        if (!("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) || "POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method))) {
            throw new MethodNotSupportedException(method + " not supported by " + this.getClass().getName());
        }
        try {
            uri = request.getUri();
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException(ex.getMessage(), (Throwable)ex);
        }
        String query = uri.getQuery();
        int delayMs = 0;
        boolean drip = false;
        if (query != null) {
            List params = WWWFormCodec.parse((CharSequence)query, (Charset)StandardCharsets.UTF_8);
            for (NameValuePair param : params) {
                String name = param.getName();
                String value = param.getValue();
                if ("delay".equals(name)) {
                    delayMs = Integer.parseInt(value);
                    continue;
                }
                if (!"drip".equals(name)) continue;
                drip = "1".equals(value);
            }
        }
        if ((slash = (path = uri.getPath()).lastIndexOf(47)) != -1) {
            String payload = path.substring(slash + 1);
            if (!payload.isEmpty()) {
                try {
                    n = Long.parseLong(payload);
                }
                catch (NumberFormatException ex) {
                    throw new ProtocolException("Invalid request path: " + path);
                }
            } else {
                n = 1 + (int)(Math.random() * 79.0);
            }
        } else {
            throw new ProtocolException("Invalid request path: " + path);
        }
        response.setCode(200);
        response.setEntity((HttpEntity)new RandomEntity(n, delayMs, drip));
    }

    public static class RandomEntity
    extends AbstractHttpEntity {
        private static final byte[] RANGE = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".getBytes(StandardCharsets.US_ASCII);
        protected final long length;
        protected final int delayMs;
        protected final boolean drip;

        public RandomEntity(long len) {
            this(len, 0, false);
        }

        public RandomEntity(long len, int delayMs, boolean drip) {
            super((ContentType)null, null);
            this.length = len;
            this.delayMs = delayMs;
            this.drip = drip;
        }

        public final boolean isStreaming() {
            return false;
        }

        public boolean isRepeatable() {
            return true;
        }

        public long getContentLength() {
            return this.length;
        }

        public InputStream getContent() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream out) throws IOException {
            try {
                int blocksize = 2048;
                int remaining = (int)this.length;
                byte[] data = new byte[Math.min(remaining, 2048)];
                out.flush();
                if (!this.drip) {
                    this.delay();
                }
                while (remaining > 0) {
                    int end = Math.min(remaining, data.length);
                    double value = 0.0;
                    for (int i = 0; i < end; ++i) {
                        if (i % 5 == 0) {
                            value = Math.random();
                        }
                        int d = (int)(value *= (double)RANGE.length);
                        value -= (double)d;
                        data[i] = RANGE[d];
                    }
                    out.write(data, 0, end);
                    out.flush();
                    remaining -= end;
                    if (!this.drip) continue;
                    this.delay();
                }
            }
            finally {
                out.close();
            }
        }

        private void delay() throws IOException {
            try {
                Thread.sleep(this.delayMs);
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException();
            }
        }

        public void close() throws IOException {
        }
    }
}

