/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.client.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.client.GridClientCacheMode;
import org.apache.ignite.internal.processors.rest.client.message.GridClientCacheBean;
import org.apache.ignite.internal.processors.rest.client.message.GridClientNodeMetricsBean;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridClientNodeBean
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private UUID nodeId;
    private Object consistentId;
    private Collection<String> tcpAddrs;
    private Collection<String> tcpHostNames;
    private int tcpPort;
    private GridClientNodeMetricsBean metrics;
    private Map<String, Object> attrs;
    private Collection<GridClientCacheBean> caches;
    private long order;

    public UUID getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public Object getConsistentId() {
        return this.consistentId;
    }

    public void setConsistentId(Object consistentId) {
        this.consistentId = consistentId;
    }

    public Collection<String> getTcpAddresses() {
        return this.tcpAddrs;
    }

    public Collection<String> getTcpHostNames() {
        return this.tcpHostNames;
    }

    public void setTcpAddresses(Collection<String> tcpAddrs) {
        this.tcpAddrs = tcpAddrs;
    }

    public void setTcpHostNames(Collection<String> tcpHostNames) {
        this.tcpHostNames = tcpHostNames;
    }

    public GridClientNodeMetricsBean getMetrics() {
        return this.metrics;
    }

    public void setMetrics(GridClientNodeMetricsBean metrics) {
        this.metrics = metrics;
    }

    public Map<String, Object> getAttributes() {
        return this.attrs;
    }

    public void setAttributes(Map<String, Object> attrs) {
        this.attrs = attrs;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public Collection<GridClientCacheBean> getCaches() {
        return this.caches;
    }

    public void setCaches(Collection<GridClientCacheBean> caches) {
        this.caches = caches;
    }

    public void setTcpPort(int tcpPort) {
        this.tcpPort = tcpPort;
    }

    public long getOrder() {
        return this.order;
    }

    public void setOrder(long order) {
        this.order = order;
    }

    public int hashCode() {
        return this.nodeId != null ? this.nodeId.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GridClientNodeBean other = (GridClientNodeBean)obj;
        return this.nodeId == null ? other.nodeId == null : this.nodeId.equals(other.nodeId);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.tcpPort);
        out.writeInt(0);
        String dfltCacheMode = null;
        HashMap<String, String> cacheMap = null;
        if (this.caches != null) {
            cacheMap = U.newHashMap(this.caches.size());
            for (GridClientCacheBean cacheBean : this.caches) {
                if (cacheBean.getName() == null) {
                    dfltCacheMode = cacheBean.getMode().toString();
                }
                cacheMap.put(cacheBean.getName(), cacheBean.getMode().toString());
            }
        }
        U.writeString(out, dfltCacheMode);
        U.writeMap(out, this.attrs);
        U.writeMap(out, cacheMap);
        U.writeCollection(out, this.tcpAddrs);
        U.writeCollection(out, this.tcpHostNames);
        U.writeCollection(out, Collections.emptyList());
        U.writeCollection(out, Collections.emptyList());
        U.writeUuid(out, this.nodeId);
        out.writeObject(String.valueOf(this.consistentId));
        out.writeObject(this.metrics);
        out.writeLong(this.order);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tcpPort = in.readInt();
        in.readInt();
        String dfltCacheMode = U.readString(in);
        this.attrs = U.readMap(in);
        Map cacheMap = U.readMap(in);
        if (cacheMap == null && dfltCacheMode != null) {
            cacheMap = U.newHashMap(1);
            cacheMap.put(null, dfltCacheMode);
        }
        if (cacheMap != null) {
            this.caches = new ArrayList<GridClientCacheBean>(cacheMap.size());
            for (Map.Entry e : cacheMap.entrySet()) {
                this.caches.add(new GridClientCacheBean((String)e.getKey(), GridClientCacheMode.valueOf((String)e.getValue()), null));
            }
        }
        this.tcpAddrs = U.readCollection(in);
        this.tcpHostNames = U.readCollection(in);
        U.readCollection(in);
        U.readCollection(in);
        this.nodeId = U.readUuid(in);
        this.consistentId = in.readObject();
        this.metrics = (GridClientNodeMetricsBean)in.readObject();
        this.order = in.readLong();
    }

    public String toString() {
        return "GridClientNodeBean [id=" + this.nodeId + "]";
    }
}

