/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.index;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class IndexDescriptor {
    private final String name;
    private final List<String> columns;

    public IndexDescriptor(String name, List<String> columns) {
        if (new HashSet<String>(columns).size() != columns.size()) {
            throw new IllegalArgumentException("Indexed columns should be unique");
        }
        this.name = Objects.requireNonNull(name, "name");
        this.columns = List.copyOf((Collection)Objects.requireNonNull(columns, "columns"));
    }

    public String name() {
        return this.name;
    }

    public List<String> columns() {
        return this.columns;
    }
}

