/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDialectFactory;
import org.apache.calcite.sql.SqlDialects;
import org.apache.calcite.sql.dialect.AccessSqlDialect;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.dialect.BigQuerySqlDialect;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.dialect.ClickHouseSqlDialect;
import org.apache.calcite.sql.dialect.Db2SqlDialect;
import org.apache.calcite.sql.dialect.DerbySqlDialect;
import org.apache.calcite.sql.dialect.ExasolSqlDialect;
import org.apache.calcite.sql.dialect.FirebirdSqlDialect;
import org.apache.calcite.sql.dialect.FireboltSqlDialect;
import org.apache.calcite.sql.dialect.H2SqlDialect;
import org.apache.calcite.sql.dialect.HiveSqlDialect;
import org.apache.calcite.sql.dialect.HsqldbSqlDialect;
import org.apache.calcite.sql.dialect.InfobrightSqlDialect;
import org.apache.calcite.sql.dialect.InformixSqlDialect;
import org.apache.calcite.sql.dialect.IngresSqlDialect;
import org.apache.calcite.sql.dialect.InterbaseSqlDialect;
import org.apache.calcite.sql.dialect.JethroDataSqlDialect;
import org.apache.calcite.sql.dialect.LucidDbSqlDialect;
import org.apache.calcite.sql.dialect.MssqlSqlDialect;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;
import org.apache.calcite.sql.dialect.NeoviewSqlDialect;
import org.apache.calcite.sql.dialect.NetezzaSqlDialect;
import org.apache.calcite.sql.dialect.OracleSqlDialect;
import org.apache.calcite.sql.dialect.ParaccelSqlDialect;
import org.apache.calcite.sql.dialect.PhoenixSqlDialect;
import org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import org.apache.calcite.sql.dialect.PrestoSqlDialect;
import org.apache.calcite.sql.dialect.RedshiftSqlDialect;
import org.apache.calcite.sql.dialect.SnowflakeSqlDialect;
import org.apache.calcite.sql.dialect.SparkSqlDialect;
import org.apache.calcite.sql.dialect.SybaseSqlDialect;
import org.apache.calcite.sql.dialect.TeradataSqlDialect;
import org.apache.calcite.sql.dialect.VerticaSqlDialect;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlDialectFactoryImpl
implements SqlDialectFactory {
    public static final SqlDialectFactoryImpl INSTANCE = new SqlDialectFactoryImpl();
    private final JethroDataSqlDialect.JethroInfoCache jethroCache = JethroDataSqlDialect.createCache();

    @Override
    public SqlDialect create(DatabaseMetaData databaseMetaData) {
        String upperProductName;
        SqlDialect.Context c = SqlDialects.createContext(databaseMetaData);
        String databaseProductName = c.databaseProductName();
        try {
            if (databaseProductName == null) {
                databaseProductName = databaseMetaData.getDatabaseProductName();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("while detecting database product", e);
        }
        switch (upperProductName = databaseProductName.toUpperCase(Locale.ROOT).trim()) {
            case "ACCESS": {
                return new AccessSqlDialect(c);
            }
            case "APACHE DERBY": {
                return new DerbySqlDialect(c);
            }
            case "CLICKHOUSE": {
                return new ClickHouseSqlDialect(c);
            }
            case "DBMS:CLOUDSCAPE": {
                return new DerbySqlDialect(c);
            }
            case "EXASOL": {
                return new ExasolSqlDialect(c);
            }
            case "FIREBOLT": {
                return new FireboltSqlDialect(c);
            }
            case "HIVE": {
                return new HiveSqlDialect(c);
            }
            case "INGRES": {
                return new IngresSqlDialect(c);
            }
            case "INTERBASE": {
                return new InterbaseSqlDialect(c);
            }
            case "JETHRODATA": {
                return new JethroDataSqlDialect(c.withJethroInfo(this.jethroCache.get(databaseMetaData)));
            }
            case "LUCIDDB": {
                return new LucidDbSqlDialect(c);
            }
            case "ORACLE": {
                return new OracleSqlDialect(c);
            }
            case "PHOENIX": {
                return new PhoenixSqlDialect(c);
            }
            case "MYSQL (INFOBRIGHT)": {
                return new InfobrightSqlDialect(c);
            }
            case "MYSQL": {
                return new MysqlSqlDialect(c.withDataTypeSystem(MysqlSqlDialect.MYSQL_TYPE_SYSTEM));
            }
            case "REDSHIFT": {
                return new RedshiftSqlDialect(c.withDataTypeSystem(RedshiftSqlDialect.TYPE_SYSTEM));
            }
            case "SNOWFLAKE": {
                return new SnowflakeSqlDialect(c);
            }
            case "SPARK": {
                return new SparkSqlDialect(c);
            }
        }
        if (upperProductName.startsWith("DB2")) {
            return new Db2SqlDialect(c);
        }
        if (upperProductName.contains("FIREBIRD")) {
            return new FirebirdSqlDialect(c);
        }
        if (upperProductName.contains("FIREBOLT")) {
            return new FireboltSqlDialect(c);
        }
        if (upperProductName.contains("GOOGLE BIGQUERY") || upperProductName.contains("GOOGLE BIG QUERY")) {
            return new BigQuerySqlDialect(c);
        }
        if (upperProductName.startsWith("INFORMIX")) {
            return new InformixSqlDialect(c);
        }
        if (upperProductName.contains("NETEZZA")) {
            return new NetezzaSqlDialect(c);
        }
        if (upperProductName.contains("PARACCEL")) {
            return new ParaccelSqlDialect(c);
        }
        if (upperProductName.startsWith("HP NEOVIEW")) {
            return new NeoviewSqlDialect(c);
        }
        if (upperProductName.contains("POSTGRE")) {
            return new PostgresqlSqlDialect(c.withDataTypeSystem(PostgresqlSqlDialect.POSTGRESQL_TYPE_SYSTEM));
        }
        if (upperProductName.contains("SQL SERVER")) {
            return new MssqlSqlDialect(c);
        }
        if (upperProductName.contains("SYBASE")) {
            return new SybaseSqlDialect(c);
        }
        if (upperProductName.contains("TERADATA")) {
            return new TeradataSqlDialect(c);
        }
        if (upperProductName.contains("HSQL")) {
            return new HsqldbSqlDialect(c);
        }
        if (upperProductName.contains("H2")) {
            return new H2SqlDialect(c);
        }
        if (upperProductName.contains("VERTICA")) {
            return new VerticaSqlDialect(c);
        }
        if (upperProductName.contains("SNOWFLAKE")) {
            return new SnowflakeSqlDialect(c);
        }
        if (upperProductName.contains("SPARK")) {
            return new SparkSqlDialect(c);
        }
        return new AnsiSqlDialect(c);
    }

    static @Nullable SqlDialect simple(SqlDialect.DatabaseProduct databaseProduct) {
        switch (databaseProduct) {
            case ACCESS: {
                return AccessSqlDialect.DEFAULT;
            }
            case BIG_QUERY: {
                return BigQuerySqlDialect.DEFAULT;
            }
            case CALCITE: {
                return CalciteSqlDialect.DEFAULT;
            }
            case CLICKHOUSE: {
                return ClickHouseSqlDialect.DEFAULT;
            }
            case DB2: {
                return Db2SqlDialect.DEFAULT;
            }
            case DERBY: {
                return DerbySqlDialect.DEFAULT;
            }
            case EXASOL: {
                return ExasolSqlDialect.DEFAULT;
            }
            case FIREBIRD: {
                return FirebirdSqlDialect.DEFAULT;
            }
            case FIREBOLT: {
                return FireboltSqlDialect.DEFAULT;
            }
            case H2: {
                return H2SqlDialect.DEFAULT;
            }
            case HIVE: {
                return HiveSqlDialect.DEFAULT;
            }
            case HSQLDB: {
                return HsqldbSqlDialect.DEFAULT;
            }
            case INFOBRIGHT: {
                return InfobrightSqlDialect.DEFAULT;
            }
            case INFORMIX: {
                return InformixSqlDialect.DEFAULT;
            }
            case INGRES: {
                return IngresSqlDialect.DEFAULT;
            }
            case INTERBASE: {
                return InterbaseSqlDialect.DEFAULT;
            }
            case JETHRO: {
                throw new RuntimeException("Jethro does not support simple creation");
            }
            case LUCIDDB: {
                return LucidDbSqlDialect.DEFAULT;
            }
            case MSSQL: {
                return MssqlSqlDialect.DEFAULT;
            }
            case MYSQL: {
                return MysqlSqlDialect.DEFAULT;
            }
            case NEOVIEW: {
                return NeoviewSqlDialect.DEFAULT;
            }
            case NETEZZA: {
                return NetezzaSqlDialect.DEFAULT;
            }
            case ORACLE: {
                return OracleSqlDialect.DEFAULT;
            }
            case PARACCEL: {
                return ParaccelSqlDialect.DEFAULT;
            }
            case PHOENIX: {
                return PhoenixSqlDialect.DEFAULT;
            }
            case POSTGRESQL: {
                return PostgresqlSqlDialect.DEFAULT;
            }
            case PRESTO: {
                return PrestoSqlDialect.DEFAULT;
            }
            case REDSHIFT: {
                return RedshiftSqlDialect.DEFAULT;
            }
            case SNOWFLAKE: {
                return SnowflakeSqlDialect.DEFAULT;
            }
            case SPARK: {
                return SparkSqlDialect.DEFAULT;
            }
            case SYBASE: {
                return SybaseSqlDialect.DEFAULT;
            }
            case TERADATA: {
                return TeradataSqlDialect.DEFAULT;
            }
            case VERTICA: {
                return VerticaSqlDialect.DEFAULT;
            }
        }
        return null;
    }
}

