/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.hash;

import org.apache.ignite.internal.pagememory.tree.IgniteTree;
import org.apache.ignite.internal.storage.pagememory.index.InlineUtils;
import org.apache.ignite.internal.storage.pagememory.index.freelist.IndexColumnsFreeList;
import org.apache.ignite.internal.storage.pagememory.index.hash.HashIndexRow;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

class InsertHashIndexRowInvokeClosure
implements IgniteTree.InvokeClosure<HashIndexRow> {
    private final HashIndexRow hashIndexRow;
    private final IndexColumnsFreeList freeList;
    private final int inlineSize;
    private IgniteTree.OperationType operationType = IgniteTree.OperationType.PUT;

    public InsertHashIndexRowInvokeClosure(HashIndexRow hashIndexRow, IndexColumnsFreeList freeList, int inlineSize) {
        assert (hashIndexRow.indexColumns().link() == 0L);
        this.hashIndexRow = hashIndexRow;
        this.freeList = freeList;
        this.inlineSize = inlineSize;
    }

    public void call(@Nullable HashIndexRow oldRow) throws IgniteInternalCheckedException {
        if (oldRow != null) {
            this.operationType = IgniteTree.OperationType.NOOP;
            return;
        }
        if (!InlineUtils.canFullyInline(this.hashIndexRow.indexColumns().valueSize(), this.inlineSize)) {
            this.freeList.insertDataRow(this.hashIndexRow.indexColumns());
        }
    }

    @Nullable
    public HashIndexRow newRow() {
        return this.hashIndexRow;
    }

    public IgniteTree.OperationType operationType() {
        return this.operationType;
    }
}

