/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.hash;

import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.index.HashIndexDescriptor;
import org.apache.ignite.internal.storage.index.HashIndexStorage;
import org.apache.ignite.internal.storage.index.IndexRow;
import org.apache.ignite.internal.storage.pagememory.index.freelist.IndexColumns;
import org.apache.ignite.internal.storage.pagememory.index.freelist.IndexColumnsFreeList;
import org.apache.ignite.internal.storage.pagememory.index.hash.HashIndexRow;
import org.apache.ignite.internal.storage.pagememory.index.hash.HashIndexTree;
import org.apache.ignite.internal.storage.pagememory.index.hash.InsertHashIndexRowInvokeClosure;
import org.apache.ignite.internal.storage.pagememory.index.hash.RemoveHashIndexRowInvokeClosure;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.CursorUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;

public class PageMemoryHashIndexStorage
implements HashIndexStorage {
    private final HashIndexDescriptor descriptor;
    private final IndexColumnsFreeList freeList;
    private final HashIndexTree hashIndexTree;
    private final int partitionId;
    private final RowId lowestRowId;
    private final RowId highestRowId;

    public PageMemoryHashIndexStorage(HashIndexDescriptor descriptor, IndexColumnsFreeList freeList, HashIndexTree hashIndexTree) {
        this.descriptor = descriptor;
        this.freeList = freeList;
        this.hashIndexTree = hashIndexTree;
        this.partitionId = hashIndexTree.partitionId();
        this.lowestRowId = new RowId(this.partitionId, Long.MIN_VALUE, Long.MIN_VALUE);
        this.highestRowId = new RowId(this.partitionId, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public HashIndexDescriptor indexDescriptor() {
        return this.descriptor;
    }

    public Cursor<RowId> get(BinaryTuple key) throws StorageException {
        Cursor cursor;
        IndexColumns indexColumns = new IndexColumns(this.partitionId, key.byteBuffer());
        HashIndexRow lowerBound = new HashIndexRow(indexColumns, this.lowestRowId);
        HashIndexRow upperBound = new HashIndexRow(indexColumns, this.highestRowId);
        try {
            cursor = this.hashIndexTree.find(lowerBound, upperBound);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Failed to create scan cursor", (Throwable)e);
        }
        return CursorUtils.map((Cursor)cursor, HashIndexRow::rowId);
    }

    public void put(IndexRow row) throws StorageException {
        IndexColumns indexColumns = new IndexColumns(this.partitionId, row.indexColumns().byteBuffer());
        try {
            HashIndexRow hashIndexRow = new HashIndexRow(indexColumns, row.rowId());
            InsertHashIndexRowInvokeClosure insert = new InsertHashIndexRowInvokeClosure(hashIndexRow, this.freeList, this.hashIndexTree.inlineSize());
            this.hashIndexTree.invoke(hashIndexRow, null, insert);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Failed to put value into index", (Throwable)e);
        }
    }

    public void remove(IndexRow row) throws StorageException {
        IndexColumns indexColumns = new IndexColumns(this.partitionId, row.indexColumns().byteBuffer());
        try {
            HashIndexRow hashIndexRow = new HashIndexRow(indexColumns, row.rowId());
            RemoveHashIndexRowInvokeClosure remove = new RemoveHashIndexRowInvokeClosure(hashIndexRow, this.freeList);
            this.hashIndexTree.invoke(hashIndexRow, null, remove);
            remove.afterCompletion();
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Failed to remove value from index", (Throwable)e);
        }
    }

    public void destroy() throws StorageException {
    }
}

