/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import org.apache.ignite.lang.IgniteInternalException;

public class ByteUtils {
    public static long bytesToLong(byte[] bytes, int off) {
        assert (bytes != null);
        int bytesCnt = Math.min(8, bytes.length - off);
        long res = 0L;
        for (int i = 0; i < bytesCnt; ++i) {
            res = res << 8 | 0xFFL & (long)bytes[off + i];
        }
        return res;
    }

    public static long bytesToLong(byte[] bytes) {
        return ByteUtils.bytesToLong(bytes, 0);
    }

    public static byte[] longToBytes(long l) {
        return ByteUtils.putLongToBytes(l, new byte[8], 0);
    }

    public static byte[] putLongToBytes(long l, byte[] bytes, int off) {
        assert (bytes != null);
        assert (bytes.length >= off + 8);
        for (int i = 7; i >= 0; --i) {
            bytes[off + i] = (byte)l;
            l >>>= 8;
        }
        return bytes;
    }

    public static byte[] putUuidToBytes(UUID uuid, byte[] bytes, int off) {
        ByteUtils.putLongToBytes(uuid.getMostSignificantBits(), bytes, off);
        ByteUtils.putLongToBytes(uuid.getLeastSignificantBits(), bytes, off + 8);
        return bytes;
    }

    public static UUID bytesToUuid(byte[] bytes, int off) {
        long msb = ByteUtils.bytesToLong(bytes, off);
        long lsb = ByteUtils.bytesToLong(bytes, off + 8);
        return new UUID(msb, lsb);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] toBytes(Object obj) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(obj);
                out.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new IgniteInternalException(String.format("Could not serialize a class [cls=%s]", obj.getClass()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromBytes(byte[] bytes) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream in = new ObjectInputStream(bis);){
                object = in.readObject();
            }
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IgniteInternalException("Could not deserialize an object", (Throwable)e);
        }
    }
}

