/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.time.Duration;
import java.util.Optional;
import java.util.Spliterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import me.tongfei.progressbar.ConsoleProgressBarConsumer;
import me.tongfei.progressbar.InteractiveConsoleProgressBarConsumer;
import me.tongfei.progressbar.ProgressState;
import me.tongfei.progressbar.TerminalUtils;

class Util {
    static ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, runnable -> {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setName("ProgressBar");
        thread.setDaemon(true);
        return thread;
    });

    Util() {
    }

    static ConsoleProgressBarConsumer createConsoleConsumer(int predefinedWidth) {
        PrintStream real = new PrintStream(new FileOutputStream(FileDescriptor.err));
        return Util.createConsoleConsumer(real, predefinedWidth);
    }

    static ConsoleProgressBarConsumer createConsoleConsumer(PrintStream out) {
        return Util.createConsoleConsumer(out, -1);
    }

    static ConsoleProgressBarConsumer createConsoleConsumer(PrintStream out, int predefinedWidth) {
        return TerminalUtils.hasCursorMovementSupport() ? new InteractiveConsoleProgressBarConsumer(out, predefinedWidth) : new ConsoleProgressBarConsumer(out, predefinedWidth);
    }

    static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        char[] s = new char[n];
        for (int i = 0; i < n; ++i) {
            s[i] = c;
        }
        return new String(s);
    }

    static String formatDuration(Duration d) {
        long s = d.getSeconds();
        return String.format("%d:%02d:%02d", s / 3600L, s % 3600L / 60L, s % 60L);
    }

    static Optional<Duration> linearETA(ProgressState progress, Duration elapsed) {
        if (progress.max <= 0L || progress.indefinite) {
            return Optional.empty();
        }
        if (progress.current - progress.start == 0L) {
            return Optional.empty();
        }
        return Optional.of(elapsed.dividedBy(progress.current - progress.start).multipliedBy(progress.max - progress.current));
    }

    static long getInputStreamSize(InputStream is) {
        try {
            if (is instanceof FileInputStream) {
                return ((FileInputStream)is).getChannel().size();
            }
            int available = is.available();
            if (available > 0) {
                return available;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    static <T> long getSpliteratorSize(Spliterator<T> sp) {
        try {
            long size = sp.estimateSize();
            return size != Long.MAX_VALUE ? size : -1L;
        }
        catch (Exception exception) {
            return -1L;
        }
    }
}

