/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.VacuumTxStateReplicaRequest;
import org.apache.ignite.internal.tx.message.VacuumTxStateReplicaRequestBuilder;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class VacuumTxStateReplicaRequestDeserializer
implements MessageDeserializer<VacuumTxStateReplicaRequest> {
    private final VacuumTxStateReplicaRequestBuilder msg;

    VacuumTxStateReplicaRequestDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.vacuumTxStateReplicaRequest();
    }

    public Class<VacuumTxStateReplicaRequest> klass() {
        return VacuumTxStateReplicaRequest.class;
    }

    public VacuumTxStateReplicaRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.enlistmentConsistencyToken((Long)tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId((ReplicationGroupIdMessage)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readSet("transactionIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.transactionIds((Set<UUID>)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(VacuumTxStateReplicaRequest.class);
    }
}

