/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.configuration;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.presentation.ConfigurationPresentation;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;

public abstract class AbstractConfigurationController
implements ResourceHolder {
    private ConfigurationPresentation<String> cfgPresentation;

    public AbstractConfigurationController(ConfigurationPresentation<String> cfgPresentation) {
        this.cfgPresentation = cfgPresentation;
    }

    public String getConfiguration() {
        return (String)this.cfgPresentation.represent();
    }

    public String getConfigurationByPath(String path) {
        try {
            return (String)this.cfgPresentation.representByPath(path);
        }
        catch (IllegalArgumentException ex) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)ex);
        }
    }

    public CompletableFuture<Void> updateConfiguration(String updatedConfiguration) {
        return this.cfgPresentation.update((Object)updatedConfiguration).exceptionally(ex -> {
            Throwable cause;
            if (ex instanceof CompletionException && ((cause = ex.getCause()) instanceof IllegalArgumentException || cause instanceof ConfigurationValidationException)) {
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, cause);
            }
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, ex);
        });
    }

    public void cleanResources() {
        this.cfgPresentation = null;
    }
}

