/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.replicator;

import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadWriteReplicaRequest;
import org.apache.ignite3.internal.table.distributed.index.IndexMeta;
import org.apache.ignite3.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite3.internal.tx.TransactionIds;
import org.jetbrains.annotations.Nullable;

class ReplicatorUtils {
    ReplicatorUtils() {
    }

    @Nullable
    static IndexMeta latestIndexMetaInBuildingStatus(CatalogService catalogService, IndexMetaStorage indexMetaStorage, int tableId) {
        int latestCatalogVersion = catalogService.latestCatalogVersion();
        int earliestCatalogVersion = catalogService.earliestCatalogVersion();
        for (int catalogVersion = latestCatalogVersion; catalogVersion >= earliestCatalogVersion; --catalogVersion) {
            for (CatalogIndexDescriptor indexDescriptor : catalogService.catalog(catalogVersion).indexes(tableId)) {
                IndexMeta indexMeta;
                if (indexDescriptor.status() != CatalogIndexStatus.BUILDING || (indexMeta = indexMetaStorage.indexMeta(indexDescriptor.id())) == null) continue;
                return indexMeta;
            }
        }
        return null;
    }

    static HybridTimestamp beginRwTxTs(ReadWriteReplicaRequest request) {
        return TransactionIds.beginTimestamp(request.transactionId());
    }

    static int rwTxActiveCatalogVersion(CatalogService catalogService, ReadWriteReplicaRequest request) {
        HybridTimestamp beginRwTxTs = ReplicatorUtils.beginRwTxTs(request);
        return catalogService.activeCatalogVersion(beginRwTxTs.longValue());
    }
}

