/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import javax.cache.Cache;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import javax.sql.DataSource;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.store.CacheStoreAdapter;
import org.apache.ignite.cache.store.CacheStoreSession;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.CacheStoreSessionResource;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.transactions.Transaction;
import org.jetbrains.annotations.Nullable;

public class CacheJdbcBlobStore<K, V>
extends CacheStoreAdapter<K, V> {
    public static final String DFLT_CONN_URL = "jdbc:h2:mem:jdbcCacheStore;DB_CLOSE_DELAY=-1";
    public static final String DFLT_CREATE_TBL_QRY = "create table if not exists ENTRIES (akey binary primary key, val binary)";
    public static final String DFLT_LOAD_QRY = "select * from ENTRIES where akey=?";
    public static final String DFLT_UPDATE_QRY = "update ENTRIES set val=? where akey=?";
    public static final String DFLT_INSERT_QRY = "insert into ENTRIES (akey, val) values (?, ?)";
    public static final String DFLT_DEL_QRY = "delete from ENTRIES where akey=?";
    private static final String ATTR_CONN = "JDBC_STORE_CONNECTION";
    private static final Marshaller marsh = new JdkMarshaller();
    private String connUrl = "jdbc:h2:mem:jdbcCacheStore;DB_CLOSE_DELAY=-1";
    private String createTblQry = "create table if not exists ENTRIES (akey binary primary key, val binary)";
    private String loadQry = "select * from ENTRIES where akey=?";
    private String updateQry = "update ENTRIES set val=? where akey=?";
    private String insertQry = "insert into ENTRIES (akey, val) values (?, ?)";
    private String delQry = "delete from ENTRIES where akey=?";
    private String user;
    @GridToStringExclude
    private String passwd;
    private DataSource dataSrc;
    private boolean initSchema = true;
    @CacheStoreSessionResource
    private CacheStoreSession ses;
    @LoggerResource
    private IgniteLogger log;
    @IgniteInstanceResource
    private Ignite ignite;
    @GridToStringExclude
    private final AtomicBoolean initGuard = new AtomicBoolean();
    @GridToStringExclude
    private final CountDownLatch initLatch = new CountDownLatch(1);
    @GridToStringExclude
    private final LongAdder opened = new LongAdder();
    @GridToStringExclude
    private final LongAdder closed = new LongAdder();
    @GridToStringExclude
    private boolean testMode;
    private boolean initOk;

    @Override
    public void sessionEnd(boolean commit) {
        this.init();
        Transaction tx = this.transaction();
        Map props = this.session().properties();
        Connection conn = (Connection)props.remove(ATTR_CONN);
        if (conn != null) {
            try {
                if (commit) {
                    conn.commit();
                } else {
                    conn.rollback();
                }
            }
            catch (SQLException e) {
                throw new CacheWriterException("Failed to end transaction [xid=" + tx.xid() + ", commit=" + commit + ']', (Throwable)e);
            }
            finally {
                this.closeConnection(conn);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Transaction ended [xid=" + tx.xid() + ", commit=" + commit + ']');
        }
    }

    public V load(K key) {
        PreparedStatement stmt;
        Connection conn;
        Transaction tx;
        block5: {
            Object x;
            this.init();
            tx = this.transaction();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Store load [key=" + key + ", tx=" + tx + ']');
            }
            conn = null;
            stmt = null;
            try {
                conn = this.connection(tx);
                stmt = conn.prepareStatement(this.loadQry);
                stmt.setObject(1, this.toBytes(key));
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                x = this.fromBytes(rs.getBytes(2));
                this.end(tx, conn, stmt);
            }
            catch (SQLException | IgniteCheckedException e) {
                try {
                    throw new CacheLoaderException("Failed to load object: " + key, (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.end(tx, conn, stmt);
                    throw throwable;
                }
            }
            return (V)x;
        }
        this.end(tx, conn, stmt);
        return null;
    }

    public void write(Cache.Entry<? extends K, ? extends V> entry) {
        this.init();
        Transaction tx = this.transaction();
        Object key = entry.getKey();
        Object val = entry.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug(S.toString("Store put", "key", key, true, "val", val, true, "tx", (Object)tx, false));
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.connection(tx);
            stmt = conn.prepareStatement(this.updateQry);
            stmt.setObject(1, this.toBytes(val));
            stmt.setObject(2, this.toBytes(key));
            if (stmt.executeUpdate() == 0) {
                stmt.close();
                stmt = conn.prepareStatement(this.insertQry);
                stmt.setObject(1, this.toBytes(key));
                stmt.setObject(2, this.toBytes(val));
                stmt.executeUpdate();
            }
            this.end(tx, conn, stmt);
        }
        catch (SQLException | IgniteCheckedException e) {
            try {
                throw new CacheWriterException("Failed to put object [key=" + key + ", val=" + val + ']', (Throwable)e);
            }
            catch (Throwable throwable) {
                this.end(tx, conn, stmt);
                throw throwable;
            }
        }
    }

    public void delete(Object key) {
        this.init();
        Transaction tx = this.transaction();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Store remove [key=" + key + ", tx=" + tx + ']');
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.connection(tx);
            stmt = conn.prepareStatement(this.delQry);
            stmt.setObject(1, this.toBytes(key));
            stmt.executeUpdate();
            this.end(tx, conn, stmt);
        }
        catch (SQLException | IgniteCheckedException e) {
            try {
                throw new CacheWriterException("Failed to remove object: " + key, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.end(tx, conn, stmt);
                throw throwable;
            }
        }
    }

    private Connection connection(@Nullable Transaction tx) throws SQLException {
        if (tx != null) {
            Map<String, Connection> props = this.session().properties();
            Connection conn = (Connection)props.get(ATTR_CONN);
            if (conn == null) {
                conn = this.openConnection(false);
                props.put(ATTR_CONN, conn);
            }
            return conn;
        }
        return this.openConnection(true);
    }

    private void end(@Nullable Transaction tx, Connection conn, Statement st) {
        U.closeQuiet(st);
        if (tx == null) {
            this.closeConnection(conn);
        }
    }

    private Connection openConnection(boolean autocommit) throws SQLException {
        Connection conn;
        Connection connection = conn = this.dataSrc != null ? this.dataSrc.getConnection() : DriverManager.getConnection(this.connUrl, this.user, this.passwd);
        if (this.testMode) {
            this.opened.increment();
        }
        conn.setAutoCommit(autocommit);
        return conn;
    }

    private void closeConnection(Connection conn) {
        U.closeQuiet(conn);
        if (this.testMode) {
            this.closed.increment();
        }
    }

    private void init() {
        block11: {
            block12: {
                if (this.initLatch.getCount() <= 0L) break block11;
                if (!this.initGuard.compareAndSet(false, true)) break block12;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Initializing cache store.");
                }
                if (F.isEmpty(this.connUrl)) {
                    throw new IgniteException("Failed to initialize cache store (connection URL is not provided).");
                }
                if (!this.initSchema) {
                    this.initLatch.countDown();
                    return;
                }
                if (F.isEmpty(this.createTblQry)) {
                    throw new IgniteException("Failed to initialize cache store (create table query is not provided).");
                }
                Connection conn = null;
                Statement stmt = null;
                try {
                    conn = this.openConnection(false);
                    stmt = conn.createStatement();
                    stmt.execute(this.createTblQry);
                    conn.commit();
                    this.initOk = true;
                }
                catch (SQLException e) {
                    try {
                        throw new IgniteException("Failed to create database table.", e);
                    }
                    catch (Throwable throwable) {
                        U.closeQuiet(stmt);
                        this.closeConnection(conn);
                        this.initLatch.countDown();
                        throw throwable;
                    }
                }
                U.closeQuiet(stmt);
                this.closeConnection(conn);
                this.initLatch.countDown();
                break block11;
            }
            try {
                U.await(this.initLatch);
            }
            catch (IgniteInterruptedCheckedException e) {
                throw new IgniteException(e);
            }
        }
        if (!this.initOk) {
            throw new IgniteException("Cache store was not properly initialized.");
        }
    }

    public void setInitSchema(boolean initSchema) {
        this.initSchema = initSchema;
    }

    public void setConnectionUrl(String connUrl) {
        this.connUrl = connUrl;
    }

    public void setCreateTableQuery(String createTblQry) {
        this.createTblQry = createTblQry;
    }

    public void setLoadQuery(String loadQry) {
        this.loadQry = loadQry;
    }

    public void setUpdateQuery(String updateQry) {
        this.updateQry = updateQry;
    }

    public void setInsertQuery(String insertQry) {
        this.insertQry = insertQry;
    }

    public void setDeleteQuery(String delQry) {
        this.delQry = delQry;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String passwd) {
        this.passwd = passwd;
    }

    public void setDataSource(DataSource dataSrc) {
        this.dataSrc = dataSrc;
    }

    @Override
    public String toString() {
        return S.toString(CacheJdbcBlobStore.class, this, "passwd", (Object)(this.passwd != null ? "*" : null));
    }

    protected byte[] toBytes(Object obj) throws IgniteCheckedException {
        return U.marshal(marsh, obj);
    }

    protected <X> X fromBytes(byte[] bytes) throws IgniteCheckedException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return (X)U.unmarshal(marsh, bytes, this.getClass().getClassLoader());
    }

    @Nullable
    private Transaction transaction() {
        CacheStoreSession ses = this.session();
        return ses != null ? ses.transaction() : null;
    }

    protected CacheStoreSession session() {
        return this.ses;
    }
}

