/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.query.VisorQueryIndexField;

public class VisorQueryIndex
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private QueryIndexType type;
    private List<VisorQueryIndexField> fields;

    public VisorQueryIndex() {
    }

    public VisorQueryIndex(QueryIndex idx) {
        assert (idx != null);
        this.name = idx.getName();
        this.type = idx.getIndexType();
        this.fields = VisorQueryIndexField.list(idx);
    }

    public String getName() {
        return this.name;
    }

    public QueryIndexType getType() {
        return this.type;
    }

    public List<VisorQueryIndexField> getFields() {
        return this.fields;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        U.writeEnum(out, this.type);
        U.writeCollection(out, this.fields);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.type = QueryIndexType.fromOrdinal(in.readByte());
        this.fields = U.readList(in);
    }

    public String toString() {
        return S.toString(VisorQueryIndex.class, this);
    }
}

