/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.iceberg.service.IcebergCatalogWrapperManager;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/{prefix:([^/]*/)?}namespaces")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IcebergNamespaceOperations {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergNamespaceOperations.class);
    private IcebergCatalogWrapperManager icebergCatalogWrapperManager;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public IcebergNamespaceOperations(IcebergCatalogWrapperManager icebergCatalogWrapperManager) {
        this.icebergCatalogWrapperManager = icebergCatalogWrapperManager;
    }

    @GET
    @Produces(value={"application/json"})
    @Timed(name="list-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-namespace", absolute=true)
    public Response listNamespaces(@DefaultValue(value="") @QueryParam(value="parent") String parent, @PathParam(value="prefix") String prefix) {
        Namespace parentNamespace = parent.isEmpty() ? Namespace.empty() : RESTUtil.decodeNamespace((String)parent);
        ListNamespacesResponse response = this.icebergCatalogWrapperManager.getOps(prefix).listNamespace(parentNamespace);
        return IcebergRestUtils.ok(response);
    }

    @GET
    @Path(value="{namespace}")
    @Produces(value={"application/json"})
    @Timed(name="load-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="load-namespace", absolute=true)
    public Response loadNamespace(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace) {
        GetNamespaceResponse getNamespaceResponse = this.icebergCatalogWrapperManager.getOps(prefix).loadNamespace(RESTUtil.decodeNamespace((String)namespace));
        return IcebergRestUtils.ok(getNamespaceResponse);
    }

    @DELETE
    @Path(value="{namespace}")
    @Produces(value={"application/json"})
    @Timed(name="drop-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-namespace", absolute=true)
    public Response dropNamespace(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace) {
        LOG.info("Drop Iceberg namespace: {}, prefix: {}", (Object)namespace, (Object)prefix);
        this.icebergCatalogWrapperManager.getOps(prefix).dropNamespace(RESTUtil.decodeNamespace((String)namespace));
        return IcebergRestUtils.noContent();
    }

    @POST
    @Produces(value={"application/json"})
    @Timed(name="create-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-namespace", absolute=true)
    public Response createNamespace(@PathParam(value="prefix") String prefix, CreateNamespaceRequest namespaceRequest) {
        LOG.info("Create Iceberg namespace: {}, prefix: {}", (Object)namespaceRequest, (Object)prefix);
        CreateNamespaceResponse response = this.icebergCatalogWrapperManager.getOps(prefix).createNamespace(namespaceRequest);
        return IcebergRestUtils.ok(response);
    }

    @POST
    @Path(value="{namespace}/properties")
    @Produces(value={"application/json"})
    @Timed(name="update-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="update-namespace", absolute=true)
    public Response updateNamespace(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, UpdateNamespacePropertiesRequest request) {
        LOG.info("Update Iceberg namespace: {}, request: {}, prefix: {}", new Object[]{namespace, request, prefix});
        UpdateNamespacePropertiesResponse response = this.icebergCatalogWrapperManager.getOps(prefix).updateNamespaceProperties(RESTUtil.decodeNamespace((String)namespace), request);
        return IcebergRestUtils.ok(response);
    }

    @POST
    @Path(value="{namespace}/register")
    @Produces(value={"application/json"})
    @Timed(name="register-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="register-table", absolute=true)
    public Response registerTable(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, RegisterTableRequest request) {
        LOG.info("Register table, namespace: {}, request: {}", (Object)namespace, (Object)request);
        LoadTableResponse response = this.icebergCatalogWrapperManager.getOps(prefix).registerTable(RESTUtil.decodeNamespace((String)namespace), request);
        return IcebergRestUtils.ok(response);
    }
}

