/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.credential.Credential;

public class GCSTokenCredential
implements Credential {
    public static final String GCS_TOKEN_CREDENTIAL_TYPE = "gcs-token";
    public static final String GCS_TOKEN_NAME = "token";
    private final String token;
    private final long expireMs;

    public GCSTokenCredential(String token, long expireMs) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)token), (Object)"GCS session token should not be null");
        this.token = token;
        this.expireMs = expireMs;
    }

    @Override
    public String credentialType() {
        return GCS_TOKEN_CREDENTIAL_TYPE;
    }

    @Override
    public long expireTimeInMs() {
        return this.expireMs;
    }

    @Override
    public Map<String, String> credentialInfo() {
        return new ImmutableMap.Builder().put((Object)GCS_TOKEN_NAME, (Object)this.token).build();
    }

    public String token() {
        return this.token;
    }
}

