/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.connector.PropertiesMetadata;
import org.apache.gravitino.connector.PropertyEntry;

public class PropertiesMetadataHelpers {
    private PropertiesMetadataHelpers() {
    }

    public static <T> T checkValueFormat(String key, String value, Function<String, T> decoder) {
        try {
            return decoder.apply(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid value: '%s' for property: '%s'", value, key), e);
        }
    }

    public static void validatePropertyForCreate(PropertiesMetadata propertiesMetadata, Map<String, String> properties) throws IllegalArgumentException {
        if (properties == null) {
            return;
        }
        List reservedProperties = properties.keySet().stream().filter(propertiesMetadata::isReservedProperty).collect(Collectors.toList());
        Preconditions.checkArgument((boolean)reservedProperties.isEmpty(), (String)"Properties are reserved and cannot be set: %s", reservedProperties);
        List absentProperties = propertiesMetadata.propertyEntries().keySet().stream().filter(propertiesMetadata::isRequiredProperty).filter(k -> !properties.containsKey(k)).collect(Collectors.toList());
        Preconditions.checkArgument((boolean)absentProperties.isEmpty(), (String)"Properties are required and must be set: %s", absentProperties);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!propertiesMetadata.containsProperty(key)) continue;
            PropertiesMetadataHelpers.checkValueFormat(key, value, propertiesMetadata.propertyEntries().get(key)::decode);
        }
    }

    public static void validatePropertyForAlter(PropertiesMetadata propertiesMetadata, Map<String, String> upserts, Map<String, String> deletes) {
        PropertyEntry<?> propertyEntry;
        for (Map.Entry<String, String> entry : upserts.entrySet()) {
            propertyEntry = propertiesMetadata.propertyEntries().get(entry.getKey());
            if (!Objects.nonNull(propertyEntry)) continue;
            Preconditions.checkArgument((!propertyEntry.isImmutable() && !propertyEntry.isReserved() ? 1 : 0) != 0, (Object)("Property " + propertyEntry.getName() + " is immutable or reserved, cannot be set"));
            PropertiesMetadataHelpers.checkValueFormat(entry.getKey(), entry.getValue(), propertyEntry::decode);
        }
        for (Map.Entry<String, String> entry : deletes.entrySet()) {
            propertyEntry = propertiesMetadata.propertyEntries().get(entry.getKey());
            if (!Objects.nonNull(propertyEntry)) continue;
            Preconditions.checkArgument((!propertyEntry.isImmutable() && !propertyEntry.isReserved() ? 1 : 0) != 0, (Object)("Property " + propertyEntry.getName() + " is immutable or reserved, cannot be deleted"));
        }
    }
}

