/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class PropertyEntry<T> {
    private final String name;
    private final String description;
    private final boolean required;
    private final boolean immutable;
    private final Class<T> javaType;
    private final T defaultValue;
    private final Function<String, T> decoder;
    private final Function<T, String> encoder;
    private final boolean hidden;
    private final boolean reserved;

    private PropertyEntry(String name, String description, boolean required, boolean immutable, Class<T> javaType, T defaultValue, Function<String, T> decoder, Function<T, String> encoder, boolean hidden, boolean reserved) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"name cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)description), (Object)"description cannot be null or empty");
        Preconditions.checkArgument((javaType != null ? 1 : 0) != 0, (Object)"javaType cannot be null");
        Preconditions.checkArgument((decoder != null ? 1 : 0) != 0, (Object)"decoder cannot be null");
        Preconditions.checkArgument((encoder != null ? 1 : 0) != 0, (Object)"encoder cannot be null");
        Preconditions.checkArgument((!required || defaultValue == null ? 1 : 0) != 0, (Object)"defaultValue cannot be set for required property");
        Preconditions.checkArgument((!required || !reserved ? 1 : 0) != 0, (Object)"required property cannot be reserved");
        Preconditions.checkArgument((!reserved || immutable ? 1 : 0) != 0, (Object)"reserved property must be immutable");
        this.name = name;
        this.description = description;
        this.required = required;
        this.immutable = immutable;
        this.javaType = javaType;
        this.defaultValue = defaultValue;
        this.decoder = decoder;
        this.encoder = encoder;
        this.hidden = hidden;
        this.reserved = reserved;
    }

    public T decode(String value) {
        return this.decoder.apply(value);
    }

    public static PropertyEntry<String> stringPropertyEntry(String name, String description, boolean required, boolean immutable, String defaultValue, boolean hidden, boolean reserved) {
        return new Builder().withName(name).withDescription(description).withRequired(required).withImmutable(immutable).withJavaType(String.class).withDefaultValue(defaultValue).withDecoder(Function.identity()).withEncoder(Function.identity()).withHidden(hidden).withReserved(reserved).build();
    }

    public static PropertyEntry<Long> longPropertyEntry(String name, String description, boolean required, boolean immutable, long defaultValue, boolean hidden, boolean reserved) {
        return new Builder().withName(name).withDescription(description).withRequired(required).withImmutable(immutable).withJavaType(Long.class).withDefaultValue(defaultValue).withDecoder(Long::parseLong).withEncoder(String::valueOf).withHidden(hidden).withReserved(reserved).build();
    }

    public static PropertyEntry<Integer> integerPropertyEntry(String name, String description, boolean required, boolean immutable, Integer defaultValue, boolean hidden, boolean reserved) {
        return new Builder().withName(name).withDescription(description).withRequired(required).withImmutable(immutable).withJavaType(Integer.class).withDefaultValue(defaultValue).withDecoder(Integer::parseInt).withEncoder(String::valueOf).withHidden(hidden).withReserved(reserved).build();
    }

    public static PropertyEntry<Short> shortPropertyEntry(String name, String description, boolean required, boolean immutable, Short defaultValue, boolean hidden, boolean reserved) {
        return new Builder().withName(name).withDescription(description).withRequired(required).withImmutable(immutable).withJavaType(Short.class).withDefaultValue(defaultValue).withDecoder(Short::parseShort).withEncoder(String::valueOf).withHidden(hidden).withReserved(reserved).build();
    }

    public static PropertyEntry<String> stringReservedPropertyEntry(String name, String description, boolean hidden) {
        return PropertyEntry.stringPropertyEntry(name, description, false, true, null, hidden, true);
    }

    public static PropertyEntry<Boolean> booleanReservedPropertyEntry(String name, String description, boolean defaultValue, boolean hidden) {
        return PropertyEntry.booleanPropertyEntry(name, description, false, true, defaultValue, hidden, true);
    }

    public static PropertyEntry<Boolean> booleanPropertyEntry(String name, String description, boolean required, boolean immutable, Boolean defaultValue, boolean hidden, boolean reserved) {
        return new Builder().withName(name).withDescription(description).withRequired(required).withImmutable(immutable).withJavaType(Boolean.class).withDefaultValue(defaultValue).withDecoder(Boolean::valueOf).withEncoder(b -> Boolean.toString(b).toUpperCase()).withHidden(hidden).withReserved(reserved).build();
    }

    public static PropertyEntry<String> stringRequiredPropertyEntry(String name, String description, boolean immutable, boolean hidden) {
        return PropertyEntry.stringPropertyEntry(name, description, true, immutable, null, hidden, false);
    }

    public static PropertyEntry<String> stringOptionalPropertyEntry(String name, String description, boolean immutable, String defaultValue, boolean hidden) {
        return PropertyEntry.stringPropertyEntry(name, description, false, immutable, defaultValue, hidden, false);
    }

    public static PropertyEntry<String> stringMutablePropertyEntry(String name, String description, boolean required, String defaultValue, boolean hidden) {
        return PropertyEntry.stringPropertyEntry(name, description, required, false, defaultValue, hidden, false);
    }

    public static PropertyEntry<Short> shortOptionalPropertyEntry(String name, String description, boolean immutable, Short defaultValue, boolean hidden) {
        return PropertyEntry.shortPropertyEntry(name, description, false, immutable, defaultValue, hidden, false);
    }

    public static PropertyEntry<Integer> integerOptionalPropertyEntry(String name, String description, boolean immutable, Integer defaultValue, boolean hidden) {
        return PropertyEntry.integerPropertyEntry(name, description, false, immutable, defaultValue, hidden, false);
    }

    public static PropertyEntry<Long> longOptionalPropertyEntry(String name, String description, boolean immutable, long defaultValue, boolean hidden) {
        return PropertyEntry.longPropertyEntry(name, description, false, immutable, defaultValue, hidden, false);
    }

    public static PropertyEntry<String> stringImmutablePropertyEntry(String name, String description, boolean required, String defaultValue, boolean hidden, boolean reserved) {
        return PropertyEntry.stringPropertyEntry(name, description, required, true, defaultValue, hidden, reserved);
    }

    public static <T extends Enum<T>> PropertyEntry<T> enumPropertyEntry(String name, String description, boolean required, boolean immutable, Class<T> javaType, T defaultValue, boolean hidden, boolean reserved) {
        String validValues = EnumSet.allOf(javaType).stream().map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(", ", "[", "]"));
        return new Builder().withName(name).withDescription(description).withRequired(required).withImmutable(immutable).withJavaType(javaType).withDefaultValue(defaultValue).withDecoder(value -> {
            try {
                return Enum.valueOf(javaType, value.toUpperCase());
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new IllegalArgumentException(String.format("Invalid value [%s]. Valid values: %s", value, validValues), e);
            }
        }).withEncoder(e -> e.name().toLowerCase()).withHidden(hidden).withReserved(reserved).build();
    }

    public static <T extends Enum<T>> PropertyEntry<T> enumImmutablePropertyEntry(String name, String description, boolean required, Class<T> javaType, T defaultValue, boolean hidden, boolean reserved) {
        return PropertyEntry.enumPropertyEntry(name, description, required, true, javaType, defaultValue, hidden, reserved);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PropertyEntry{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", required=").append(this.required);
        sb.append(", immutable=").append(this.immutable);
        sb.append(", javaType=").append(this.javaType);
        sb.append(", defaultValue=").append(this.defaultValue);
        sb.append(", hidden=").append(this.hidden);
        sb.append(", reserved=").append(this.reserved);
        sb.append('}');
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public Class<T> getJavaType() {
        return this.javaType;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Function<String, T> getDecoder() {
        return this.decoder;
    }

    public Function<T, String> getEncoder() {
        return this.encoder;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isReserved() {
        return this.reserved;
    }

    public static class Builder<T> {
        private String name;
        private String description;
        private boolean required;
        private boolean immutable;
        private Class<T> javaType;
        private T defaultValue;
        private Function<String, T> decoder;
        private Function<T, String> encoder;
        private boolean hidden;
        private boolean reserved;

        public Builder<T> withName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder<T> withRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder<T> withImmutable(boolean immutable) {
            this.immutable = immutable;
            return this;
        }

        public Builder<T> withJavaType(Class<T> javaType) {
            this.javaType = javaType;
            return this;
        }

        public Builder<T> withDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder<T> withDecoder(Function<String, T> decoder) {
            this.decoder = decoder;
            return this;
        }

        public Builder<T> withEncoder(Function<T, String> encoder) {
            this.encoder = encoder;
            return this;
        }

        public Builder<T> withHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder<T> withReserved(boolean reserved) {
            this.reserved = reserved;
            return this;
        }

        public PropertyEntry<T> build() {
            return new PropertyEntry(this.name, this.description, this.required, this.immutable, this.javaType, this.defaultValue, this.decoder, this.encoder, this.hidden, this.reserved);
        }
    }
}

