/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.gravitino.credential.CredentialProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialProviderManager {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialProviderManager.class);
    private Map<String, CredentialProvider> credentialProviders = new ConcurrentHashMap<String, CredentialProvider>();

    public void registerCredentialProvider(String catalogName, CredentialProvider credentialProvider) {
        CredentialProvider current = this.credentialProviders.putIfAbsent(catalogName, credentialProvider);
        Preconditions.checkState((!credentialProvider.equals(current) ? 1 : 0) != 0, (Object)String.format("Should not register multiple times to CredentialProviderManager, catalog: %s, credential provider: %s", catalogName, credentialProvider.credentialType()));
        LOG.info("Register catalog:%s credential provider:%s to CredentialProviderManager", (Object)catalogName, (Object)credentialProvider.credentialType());
    }

    public void unregisterCredentialProvider(String catalogName) {
        CredentialProvider credentialProvider = this.credentialProviders.remove(catalogName);
        if (credentialProvider != null) {
            LOG.info("Unregister catalog:{} credential provider:{} to CredentialProviderManager", (Object)catalogName, (Object)credentialProvider.credentialType());
            try {
                credentialProvider.close();
            }
            catch (IOException e) {
                LOG.warn("Close credential provider failed", (Throwable)e);
            }
        }
    }

    @Nullable
    public CredentialProvider getCredentialProvider(String catalogName) {
        return this.credentialProviders.get(catalogName);
    }
}

