/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class CatalogPO {
    private Long catalogId;
    private String catalogName;
    private Long metalakeId;
    private String type;
    private String provider;
    private String catalogComment;
    private String properties;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public Long getCatalogId() {
        return this.catalogId;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public String getType() {
        return this.type;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getCatalogComment() {
        return this.catalogComment;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CatalogPO)) {
            return false;
        }
        CatalogPO catalogPO = (CatalogPO)o;
        return Objects.equal((Object)this.getCatalogId(), (Object)catalogPO.getCatalogId()) && Objects.equal((Object)this.getCatalogName(), (Object)catalogPO.getCatalogName()) && Objects.equal((Object)this.getMetalakeId(), (Object)catalogPO.getMetalakeId()) && Objects.equal((Object)this.getType(), (Object)catalogPO.getType()) && Objects.equal((Object)this.getProvider(), (Object)catalogPO.getProvider()) && Objects.equal((Object)this.getCatalogComment(), (Object)catalogPO.getCatalogComment()) && Objects.equal((Object)this.getProperties(), (Object)catalogPO.getProperties()) && Objects.equal((Object)this.getAuditInfo(), (Object)catalogPO.getAuditInfo()) && Objects.equal((Object)this.getCurrentVersion(), (Object)catalogPO.getCurrentVersion()) && Objects.equal((Object)this.getLastVersion(), (Object)catalogPO.getLastVersion()) && Objects.equal((Object)this.getDeletedAt(), (Object)catalogPO.getDeletedAt());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getCatalogId(), this.getCatalogName(), this.getMetalakeId(), this.getType(), this.getProvider(), this.getCatalogComment(), this.getProperties(), this.getAuditInfo(), this.getCurrentVersion(), this.getLastVersion(), this.getDeletedAt()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final CatalogPO catalogPO = new CatalogPO();

        private Builder() {
        }

        public Builder withCatalogId(Long catalogId) {
            this.catalogPO.catalogId = catalogId;
            return this;
        }

        public Builder withCatalogName(String name) {
            this.catalogPO.catalogName = name;
            return this;
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.catalogPO.metalakeId = metalakeId;
            return this;
        }

        public Builder withType(String type) {
            this.catalogPO.type = type;
            return this;
        }

        public Builder withProvider(String provider) {
            this.catalogPO.provider = provider;
            return this;
        }

        public Builder withCatalogComment(String comment) {
            this.catalogPO.catalogComment = comment;
            return this;
        }

        public Builder withProperties(String properties) {
            this.catalogPO.properties = properties;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.catalogPO.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.catalogPO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.catalogPO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.catalogPO.deletedAt = deletedAt;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument((this.catalogPO.catalogId != null ? 1 : 0) != 0, (Object)"Catalog id is required");
            Preconditions.checkArgument((this.catalogPO.catalogName != null ? 1 : 0) != 0, (Object)"Catalog name is required");
            Preconditions.checkArgument((this.catalogPO.metalakeId != null ? 1 : 0) != 0, (Object)"Metalake id is required");
            Preconditions.checkArgument((this.catalogPO.type != null ? 1 : 0) != 0, (Object)"Catalog type is required");
            Preconditions.checkArgument((this.catalogPO.provider != null ? 1 : 0) != 0, (Object)"Catalog provider is required");
            Preconditions.checkArgument((this.catalogPO.auditInfo != null ? 1 : 0) != 0, (Object)"Audit info is required");
            Preconditions.checkArgument((this.catalogPO.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.catalogPO.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.catalogPO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
        }

        public CatalogPO build() {
            this.validate();
            return this.catalogPO;
        }
    }
}

