/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aliyun.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.SimplifiedObjectMeta;
import org.apache.iceberg.aliyun.AliyunProperties;
import org.apache.iceberg.aliyun.oss.OSSURI;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

abstract class BaseOSSFile {
    private final OSS client;
    private final OSSURI uri;
    private AliyunProperties aliyunProperties;
    private SimplifiedObjectMeta metadata;
    private final MetricsContext metrics;

    BaseOSSFile(OSS client, OSSURI uri, AliyunProperties aliyunProperties, MetricsContext metrics) {
        this.client = client;
        this.uri = uri;
        this.aliyunProperties = aliyunProperties;
        this.metrics = metrics;
    }

    public String location() {
        return this.uri.location();
    }

    public OSS client() {
        return this.client;
    }

    public OSSURI uri() {
        return this.uri;
    }

    public AliyunProperties aliyunProperties() {
        return this.aliyunProperties;
    }

    public boolean exists() {
        try {
            return this.objectMetadata() != null;
        }
        catch (OSSException e) {
            if (e.getErrorCode().equals("NoSuchBucket") || e.getErrorCode().equals("NoSuchKey")) {
                return false;
            }
            throw e;
        }
    }

    protected SimplifiedObjectMeta objectMetadata() {
        if (this.metadata == null) {
            this.metadata = this.client.getSimplifiedObjectMeta(this.uri().bucket(), this.uri().key());
        }
        return this.metadata;
    }

    protected MetricsContext metrics() {
        return this.metrics;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("file", (Object)this.uri).toString();
    }
}

