/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.rpc;

import java.util.Objects;

public class MethodDescriptor {
    private final String name;
    private final MethodType type;
    private final double limitPercent;

    public static MethodDescriptor of(String name, MethodType type) {
        return new MethodDescriptor(name, type, -1.0);
    }

    public static MethodDescriptor of(String name, MethodType type, double limitPercent) {
        return new MethodDescriptor(name, type, limitPercent);
    }

    public MethodDescriptor(String name, MethodType type, double limitPercent) {
        this.name = name;
        this.type = type;
        this.limitPercent = limitPercent;
    }

    public String getName() {
        return this.name;
    }

    public MethodType getType() {
        return this.type;
    }

    public double getLimitPercent() {
        return this.limitPercent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDescriptor that = (MethodDescriptor)o;
        return Objects.equals(this.name, that.name) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type});
    }

    public String toString() {
        return "MethodDescriptor{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", limitPercent=" + this.limitPercent + '}';
    }

    public static enum MethodType {
        UNARY,
        CLIENT_STREAMING,
        SERVER_STREAMING;

    }
}

