/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    public static final int DEFAULT_READ_BUFFER_SIZE = 4096;

    public static long lastModified(String string) {
        try {
            return new File(string).lastModified();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static byte[] readByteArrayFromResource(String string) {
        InputStream inputStream;
        block3: {
            inputStream = null;
            try {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
                if (inputStream != null) break block3;
            }
            catch (Throwable throwable) {
                FileUtil.close(inputStream);
                throw throwable;
            }
            FileUtil.close(inputStream);
            return null;
        }
        byte[] byArray = FileUtil.readByteArray(inputStream);
        FileUtil.close(inputStream);
        return byArray;
    }

    public static byte[] readByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) {
        byte[] byArray = new byte[4096];
        long l2 = 0L;
        int n2 = 0;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static String read(InputStream inputStream) {
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        return FileUtil.read(inputStreamReader);
    }

    public static String read(Reader reader) {
        try {
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[4096];
            int n2 = 0;
            while (-1 != (n2 = reader.read(cArray))) {
                stringWriter.write(cArray, 0, n2);
            }
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("read error", iOException);
        }
    }

    public static String readFromResource(String string) {
        String string2;
        InputStream inputStream;
        block4: {
            inputStream = null;
            try {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
                if (inputStream == null) {
                    inputStream = FileUtil.class.getResourceAsStream("/" + string);
                }
                if (inputStream != null) break block4;
            }
            catch (Throwable throwable) {
                FileUtil.close(inputStream);
                throw throwable;
            }
            FileUtil.close(inputStream);
            return null;
        }
        String string3 = string2 = FileUtil.read(inputStream);
        FileUtil.close(inputStream);
        return string3;
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {}
    }

    public static List readLines(File file) {
        return FileUtil.readLines(file, null);
    }

    public static List readLines(File file, String string) {
        FileInputStream fileInputStream = new FileInputStream(file);
        return FileUtil.readLines(fileInputStream, string);
    }

    public static List readLines(InputStream inputStream, String string) {
        ArrayList<String> arrayList;
        try {
            String string2;
            InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList2.add(string2);
            }
            arrayList = arrayList2;
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        return arrayList;
    }
}

