/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.util.Assert;

public class DisconnectedClientHelper {
    private static final Set<String> EXCEPTION_PHRASES = Set.of("broken pipe", "connection reset");
    private static final Set<String> EXCEPTION_TYPE_NAMES = Set.of("AbortedException", "ClientAbortException", "EOFException", "EofException", "AsyncRequestNotUsableException");
    private final Log logger;

    public DisconnectedClientHelper(String logCategory) {
        Assert.notNull((Object)logCategory, (String)"'logCategory' is required");
        this.logger = LogFactory.getLog((String)logCategory);
    }

    public boolean checkAndLogClientDisconnectedException(Throwable ex) {
        if (DisconnectedClientHelper.isClientDisconnectedException(ex)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Looks like the client has gone away", ex);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Looks like the client has gone away: " + ex + " (For a full stack trace, set the log category '" + this.logger + "' to TRACE level.)"));
            }
            return true;
        }
        return false;
    }

    public static boolean isClientDisconnectedException(Throwable ex) {
        String message = NestedExceptionUtils.getMostSpecificCause((Throwable)ex).getMessage();
        if (message != null) {
            String text = message.toLowerCase(Locale.ROOT);
            for (String phrase : EXCEPTION_PHRASES) {
                if (!text.contains(phrase)) continue;
                return true;
            }
        }
        return EXCEPTION_TYPE_NAMES.contains(ex.getClass().getSimpleName());
    }
}

