/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.expr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.hertzbeat.alert.expr.AlertExpressionBaseVisitor;
import org.apache.hertzbeat.alert.expr.AlertExpressionParser;
import org.apache.hertzbeat.warehouse.db.QueryExecutor;

public class AlertExpressionEvalVisitor
extends AlertExpressionBaseVisitor<List<Map<String, Object>>> {
    private static final String THRESHOLD = "__threshold__";
    private static final String VALUE = "__value__";
    private final QueryExecutor executor;

    public AlertExpressionEvalVisitor(QueryExecutor executor) {
        this.executor = executor;
    }

    @Override
    public List<Map<String, Object>> visitExpression(AlertExpressionParser.ExpressionContext ctx) {
        return (List)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public List<Map<String, Object>> visitParenExpr(AlertExpressionParser.ParenExprContext ctx) {
        return (List)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public List<Map<String, Object>> visitComparisonExpr(AlertExpressionParser.ComparisonExprContext ctx) {
        List leftResult = (List)this.visit((ParseTree)ctx.left);
        List rightResult = (List)this.visit((ParseTree)ctx.right);
        if (rightResult.size() == 1 && ((Map)rightResult.get(0)).containsKey(THRESHOLD)) {
            double threshold = (Double)((Map)rightResult.get(0)).get(THRESHOLD);
            String operator = ctx.op.getText();
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            for (Map item : leftResult) {
                Object queryValues = item.get(VALUE);
                if (queryValues == null) continue;
                Object matchValue = this.evaluateCondition(queryValues, operator, threshold);
                item.put(VALUE, matchValue);
                result.add(new HashMap(item));
            }
            return result;
        }
        return new LinkedList<Map<String, Object>>();
    }

    @Override
    public List<Map<String, Object>> visitAndExpr(AlertExpressionParser.AndExprContext ctx) {
        List leftOperand = (List)this.visit((ParseTree)ctx.left);
        List rightOperand = (List)this.visit((ParseTree)ctx.right);
        Map leftMap = null;
        boolean leftMatch = false;
        Map rightMap = null;
        boolean rightMatch = false;
        for (Map item : leftOperand) {
            if (leftMap == null) {
                leftMap = item;
            }
            if (item.get(VALUE) == null) continue;
            leftMap = item;
            leftMatch = true;
            break;
        }
        for (Map item : rightOperand) {
            if (rightMap == null) {
                rightMap = item;
            }
            if (item.get(VALUE) == null) continue;
            rightMap = item;
            rightMatch = true;
            break;
        }
        if (leftMatch && rightMatch) {
            rightMap.putAll(leftMap);
            return new LinkedList<Map<String, Object>>(List.of(rightMap));
        }
        if (leftMap != null) {
            leftMap.put(VALUE, null);
            return new LinkedList<Map<String, Object>>(List.of(leftMap));
        }
        if (rightMap != null) {
            rightMap.put(VALUE, null);
            return new LinkedList<Map<String, Object>>(List.of(rightMap));
        }
        return new LinkedList<Map<String, Object>>();
    }

    @Override
    public List<Map<String, Object>> visitOrExpr(AlertExpressionParser.OrExprContext ctx) {
        List leftOperand = (List)this.visit((ParseTree)ctx.left);
        List rightOperand = (List)this.visit((ParseTree)ctx.right);
        Map leftMap = null;
        boolean leftMatch = false;
        Map rightMap = null;
        boolean rightMatch = false;
        for (Map item : leftOperand) {
            if (leftMap == null) {
                leftMap = item;
            }
            if (item.get(VALUE) == null) continue;
            leftMap = item;
            leftMatch = true;
            break;
        }
        for (Map item : rightOperand) {
            if (rightMap == null) {
                rightMap = item;
            }
            if (item.get(VALUE) == null) continue;
            rightMap = item;
            rightMatch = true;
            break;
        }
        if (leftMatch && rightMatch) {
            rightMap.putAll(leftMap);
            return new LinkedList<Map<String, Object>>(List.of(rightMap));
        }
        if (leftMatch) {
            return new LinkedList<Map<String, Object>>(List.of(leftMap));
        }
        if (rightMatch) {
            return new LinkedList<Map<String, Object>>(List.of(rightMap));
        }
        if (leftMap != null && rightMap != null) {
            rightMap.putAll(leftMap);
            return new LinkedList<Map<String, Object>>(List.of(rightMap));
        }
        if (leftMap != null) {
            return new LinkedList<Map<String, Object>>(List.of(leftMap));
        }
        if (rightMap != null) {
            return new LinkedList<Map<String, Object>>(List.of(rightMap));
        }
        return new LinkedList<Map<String, Object>>();
    }

    @Override
    public List<Map<String, Object>> visitUnlessExpr(AlertExpressionParser.UnlessExprContext ctx) {
        List leftOperand = (List)this.visit((ParseTree)ctx.left);
        List rightOperand = (List)this.visit((ParseTree)ctx.right);
        Map leftMap = null;
        boolean leftMatch = false;
        Map rightMap = null;
        boolean rightMatch = false;
        for (Map item : leftOperand) {
            if (leftMap == null) {
                leftMap = item;
            }
            if (item.get(VALUE) == null) continue;
            leftMap = item;
            leftMatch = true;
            break;
        }
        for (Map item : rightOperand) {
            if (rightMap == null) {
                rightMap = item;
            }
            if (item.get(VALUE) == null) continue;
            rightMap = item;
            rightMatch = true;
            break;
        }
        if (leftMatch && !rightMatch) {
            return new LinkedList<Map<String, Object>>(List.of(leftMap));
        }
        if (leftMap != null) {
            leftMap.put(VALUE, null);
            return new LinkedList<Map<String, Object>>(List.of(leftMap));
        }
        if (rightMap != null) {
            rightMap.put(VALUE, null);
            return new LinkedList<Map<String, Object>>(List.of(rightMap));
        }
        return new LinkedList<Map<String, Object>>();
    }

    @Override
    public List<Map<String, Object>> visitQueryExpr(AlertExpressionParser.QueryExprContext ctx) {
        String query = ctx.identifier().getText();
        return this.executor.execute(query);
    }

    @Override
    public List<Map<String, Object>> visitLiteralExpr(AlertExpressionParser.LiteralExprContext ctx) {
        double value = Double.parseDouble(ctx.number().getText());
        ArrayList<Map<String, Object>> numAsList = new ArrayList<Map<String, Object>>();
        HashMap<String, Double> valueMap = new HashMap<String, Double>();
        valueMap.put(THRESHOLD, value);
        numAsList.add(valueMap);
        return numAsList;
    }

    private Object evaluateCondition(Object value, String operator, Double threshold) {
        switch (operator) {
            case ">": {
                if (value instanceof List) {
                    List values = (List)value;
                    Double doubleValue = values.stream().map(v -> Double.valueOf(v.toString())).max(Double::compareTo).orElse(null);
                    if (doubleValue != null) {
                        return doubleValue > threshold ? doubleValue : null;
                    }
                    return null;
                }
                return Double.parseDouble(value.toString()) > threshold ? value : null;
            }
            case ">=": {
                if (value instanceof List) {
                    List values = (List)value;
                    Double doubleValue = values.stream().map(v -> Double.valueOf(v.toString())).max(Double::compareTo).orElse(null);
                    if (doubleValue != null) {
                        return doubleValue >= threshold ? doubleValue : null;
                    }
                    return null;
                }
                return Double.parseDouble(value.toString()) >= threshold ? value : null;
            }
            case "<": {
                if (value instanceof List) {
                    List values = (List)value;
                    Double doubleValue = values.stream().map(v -> Double.valueOf(v.toString())).min(Double::compareTo).orElse(null);
                    if (doubleValue != null) {
                        return doubleValue < threshold ? doubleValue : null;
                    }
                    return null;
                }
                return Double.parseDouble(value.toString()) < threshold ? value : null;
            }
            case "<=": {
                if (value instanceof List) {
                    List values = (List)value;
                    Double doubleValue = values.stream().map(v -> Double.valueOf(v.toString())).min(Double::compareTo).orElse(null);
                    if (doubleValue != null) {
                        return doubleValue <= threshold ? doubleValue : null;
                    }
                    return null;
                }
                return Double.parseDouble(value.toString()) <= threshold ? value : null;
            }
            case "==": {
                if (value instanceof List) {
                    List values = (List)value;
                    for (Object v2 : values) {
                        if (!v2.equals(threshold)) continue;
                        return v2;
                    }
                    return null;
                }
                return value.equals(threshold) ? value : null;
            }
            case "!=": {
                if (value instanceof List) {
                    List values = (List)value;
                    for (Object v3 : values) {
                        if (!v3.equals(threshold)) continue;
                        return null;
                    }
                    return value;
                }
                return value.equals(threshold) ? null : value;
            }
        }
        return null;
    }
}

