/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.protocol;

import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.protocol.TBase64Utils;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TMessage;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.protocol.TSet;
import com.facebook.thrift.protocol.TStruct;
import com.facebook.thrift.transport.TTransport;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class TSimpleJSONProtocol
extends TProtocol {
    private static final byte[] COMMA = new byte[]{44};
    private static final byte[] COLON = new byte[]{58};
    private static final byte[] LBRACE = new byte[]{123};
    private static final byte[] RBRACE = new byte[]{125};
    private static final byte[] LBRACKET = new byte[]{91};
    private static final byte[] RBRACKET = new byte[]{93};
    private static final byte[] QUOTE = new byte[]{34};
    private static final byte[] BOOL_TRUE = "true".getBytes(StandardCharsets.UTF_8);
    private static final byte[] BOOL_FALSE = "false".getBytes(StandardCharsets.UTF_8);
    private static final byte WHITE_SPACE = 32;
    private static final byte TAB = 9;
    private static final byte NEW_LINE = 10;
    private static final byte CARRIAGE_RETURN = 13;
    private static final TStruct ANONYMOUS_STRUCT = new TStruct();
    private static final TField ANONYMOUS_FIELD = new TField();
    private static final TMessage EMPTY_MESSAGE = new TMessage();
    private static final TSet EMPTY_SET = new TSet();
    private static final TList EMPTY_LIST = new TList();
    private static final TMap EMPTY_MAP = new TMap();
    private static final String LIST = "list";
    private static final String SET = "set";
    private static final String MAP = "map";
    private static final long VERSION = 1L;
    protected final Context BASE_CONTEXT = new Context();
    protected Stack<Context> writeContextStack_ = new Stack();
    protected Context writeContext_ = this.BASE_CONTEXT;
    private ArrayDeque<StructReadContext> readContexts = new ArrayDeque();
    private StructReadContext currentReadContext = null;
    private Stack<JSONBaseContext> contextStack_ = new Stack();
    private JSONBaseContext context_ = new JSONBaseContext();
    private LookaheadReader reader_ = new LookaheadReader();
    private byte[] tmpbuf_ = new byte[4];
    private static final String ESCAPE_CHARS = "\"\\/bfnrt";
    private static final byte[] ESCSEQ = new byte[]{92, 117, 48, 48};
    private static final int DEF_STRING_SIZE = 16;
    private static final byte[] ESCAPE_CHAR_VALS = new byte[]{34, 92, 47, 8, 12, 10, 13, 9};
    private static final byte[] ZERO = new byte[]{48};

    protected void pushWriteContext(Context c) {
        this.writeContextStack_.push(this.writeContext_);
        this.writeContext_ = c;
    }

    protected void popWriteContext() {
        this.writeContext_ = this.writeContextStack_.pop();
    }

    protected void assertContextIsNotMapKey(String invalidKeyType) throws CollectionMapKeyException {
        if (this.writeContext_.isMapKey()) {
            throw new CollectionMapKeyException("Cannot serialize a map with keys that are of type " + invalidKeyType);
        }
    }

    public TSimpleJSONProtocol(TTransport trans) {
        super(trans);
    }

    @Override
    public void writeMessageBegin(TMessage message) throws TException {
        this.trans_.write(LBRACKET);
        this.pushWriteContext(new ListContext());
        this.writeString(message.name);
        this.writeByte(message.type);
        this.writeI32(message.seqid);
    }

    @Override
    public void writeMessageEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeStructBegin(TStruct struct) throws TException {
        this.writeContext_.write();
        this.trans_.write(LBRACE);
        this.pushWriteContext(new StructContext());
    }

    @Override
    public void writeStructEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACE);
    }

    @Override
    public void writeFieldBegin(TField field) throws TException {
        this.writeString(field.name);
    }

    @Override
    public void writeFieldEnd() {
    }

    @Override
    public void writeFieldStop() {
    }

    @Override
    public void writeMapBegin(TMap map) throws TException {
        this.assertContextIsNotMapKey(MAP);
        this.writeContext_.write();
        this.trans_.write(LBRACE);
        this.pushWriteContext(new MapContext());
    }

    @Override
    public void writeMapEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACE);
    }

    @Override
    public void writeListBegin(TList list) throws TException {
        this.assertContextIsNotMapKey(LIST);
        this.writeContext_.write();
        this.trans_.write(LBRACKET);
        this.pushWriteContext(new ListContext());
    }

    @Override
    public void writeListEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeSetBegin(TSet set) throws TException {
        this.assertContextIsNotMapKey(SET);
        this.writeContext_.write();
        this.trans_.write(LBRACKET);
        this.pushWriteContext(new ListContext());
    }

    @Override
    public void writeSetEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeBool(boolean b) throws TException {
        this.writeContext_.write();
        this.trans_.write(b ? BOOL_TRUE : BOOL_FALSE);
    }

    @Override
    public void writeByte(byte b) throws TException {
        this.writeI32(b);
    }

    @Override
    public void writeI16(short i16) throws TException {
        this.writeI32(i16);
    }

    @Override
    public void writeI32(int i32) throws TException {
        if (this.writeContext_.isMapKey()) {
            this.writeString(Integer.toString(i32));
        } else {
            this.writeContext_.write();
            this._writeStringData(Integer.toString(i32));
        }
    }

    public void _writeStringData(String s) throws TException {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        this.trans_.write(b);
    }

    @Override
    public void writeI64(long i64) throws TException {
        if (this.writeContext_.isMapKey()) {
            this.writeString(Long.toString(i64));
        } else {
            this.writeContext_.write();
            this._writeStringData(Long.toString(i64));
        }
    }

    @Override
    public void writeFloat(float flt) throws TException {
        if (this.writeContext_.isMapKey()) {
            this.writeString(Float.toString(flt));
        } else {
            this.writeContext_.write();
            this._writeStringData(Float.toString(flt));
        }
    }

    @Override
    public void writeDouble(double dub) throws TException {
        if (this.writeContext_.isMapKey()) {
            this.writeString(Double.toString(dub));
        } else {
            this.writeContext_.write();
            this._writeStringData(Double.toString(dub));
        }
    }

    @Override
    public void writeString(String str) throws TException {
        this.writeContext_.write();
        int length = str.length();
        StringBuffer escape = new StringBuffer(length + 16);
        escape.append((char)QUOTE[0]);
        block8: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    escape.append('\\');
                    escape.append(c);
                    continue block8;
                }
                case '\b': {
                    escape.append('\\');
                    escape.append('b');
                    continue block8;
                }
                case '\f': {
                    escape.append('\\');
                    escape.append('f');
                    continue block8;
                }
                case '\n': {
                    escape.append('\\');
                    escape.append('n');
                    continue block8;
                }
                case '\r': {
                    escape.append('\\');
                    escape.append('r');
                    continue block8;
                }
                case '\t': {
                    escape.append('\\');
                    escape.append('t');
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String hex = Integer.toHexString(c);
                        escape.append('\\');
                        escape.append('u');
                        for (int j = 4; j > hex.length(); --j) {
                            escape.append('0');
                        }
                        escape.append(hex);
                        continue block8;
                    }
                    escape.append(c);
                }
            }
        }
        escape.append((char)QUOTE[0]);
        this._writeStringData(escape.toString());
    }

    @Override
    public void writeBinary(byte[] bin) throws TException {
        this.writeString(new String(bin, StandardCharsets.UTF_8));
    }

    private void pushContext(JSONBaseContext c) {
        this.contextStack_.push(this.context_);
        this.context_ = c;
    }

    private void popContext() {
        this.context_ = this.contextStack_.pop();
    }

    private ByteArrayOutputStream readJSONString() throws TException {
        byte ch;
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        this.readJSONSyntaxChar(QUOTE);
        while ((ch = this.reader_.read(false)) != QUOTE[0]) {
            if (ch == ESCSEQ[0]) {
                ch = this.reader_.read(false);
                if (ch == ESCSEQ[1]) {
                    this.readJSONSyntaxChar(ZERO);
                    this.readJSONSyntaxChar(ZERO);
                    this.trans_.readAll(this.tmpbuf_, 0, 2);
                    ch = (byte)((TSimpleJSONProtocol.hexVal(this.tmpbuf_[0]) << 4) + TSimpleJSONProtocol.hexVal(this.tmpbuf_[1]));
                } else {
                    int off = ESCAPE_CHARS.indexOf(ch);
                    if (off == -1) {
                        throw new TProtocolException(1, "Expected control char");
                    }
                    ch = ESCAPE_CHAR_VALS[off];
                }
            }
            arr.write(ch);
        }
        return arr;
    }

    protected void readJSONSyntaxChar(byte[] b) throws TException {
        this.readJSONSyntaxString(b);
    }

    protected void readJSONSyntaxString(byte[] expected) throws TException {
        int i = 0;
        do {
            char ch;
            if ((ch = (char)this.reader_.read()) == expected[i]) continue;
            throw new TProtocolException(1, String.format("Unexpected character '%s' at position %d (expected %s from '%s')", Character.valueOf(ch), i, expected[i], new String(expected)));
        } while (++i < expected.length);
    }

    private static final byte hexVal(byte ch) throws TException {
        if (ch >= 48 && ch <= 57) {
            return (byte)((char)ch - 48);
        }
        if (ch >= 97 && ch <= 102) {
            return (byte)((char)ch - 97 + 10);
        }
        throw new TProtocolException(1, "Expected hex character");
    }

    private boolean isJSONNumeric(byte b) {
        switch (b) {
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 69: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    private String readJSONNumericChars() throws TException {
        byte ch;
        StringBuilder strbld = new StringBuilder();
        while (this.isJSONNumeric(ch = this.reader_.peek())) {
            strbld.append((char)this.reader_.read());
        }
        return strbld.toString();
    }

    private long readJSONInteger() throws TException {
        this.context_.read();
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        String str = this.readJSONNumericChars();
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException ex) {
            throw new TProtocolException(1, "Bad data encounted in numeric data");
        }
    }

    private double readJSONDouble() throws TException {
        this.context_.read();
        if (this.reader_.peek() == QUOTE[0]) {
            double dub;
            ByteArrayOutputStream arr = this.readJSONString();
            try {
                dub = Double.valueOf(arr.toString(StandardCharsets.UTF_8.name()));
            }
            catch (Exception e) {
                throw new TException(e);
            }
            if (!(this.context_.escapeNum() || Double.isNaN(dub) || Double.isInfinite(dub))) {
                throw new TProtocolException(1, "Numeric data unexpectedly quoted");
            }
            return dub;
        }
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        try {
            return Double.valueOf(this.readJSONNumericChars());
        }
        catch (NumberFormatException ex) {
            throw new TProtocolException(1, "Bad data encounted in numeric data");
        }
    }

    protected float readJSONFloat() throws TException {
        this.context_.read();
        if (this.reader_.peek() == QUOTE[0]) {
            String s;
            ByteArrayOutputStream arr = this.readJSONString();
            try {
                s = arr.toString(StandardCharsets.UTF_8.name());
            }
            catch (Exception e) {
                throw new TException(e);
            }
            float flt = Float.valueOf(s).floatValue();
            if (!(this.context_.escapeNum() || Float.isNaN(flt) || Float.isInfinite(flt))) {
                throw new TProtocolException(1, "Numeric data unexpectedly quoted");
            }
            return flt;
        }
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        try {
            return Float.valueOf(this.readJSONNumericChars()).floatValue();
        }
        catch (NumberFormatException ex) {
            throw new TProtocolException(1, "Bad data encounted in numeric data");
        }
    }

    private byte[] readJSONBase64() throws TException {
        ByteArrayOutputStream arr = this.readJSONString();
        byte[] b = arr.toByteArray();
        int len = b.length;
        int off = 0;
        int size = 0;
        while (len >= 4) {
            TBase64Utils.decode(b, off, 4, b, size);
            off += 4;
            len -= 4;
            size += 3;
        }
        if (len > 1) {
            TBase64Utils.decode(b, off, len, b, size);
            size += len - 1;
        }
        byte[] result = new byte[size];
        System.arraycopy(b, 0, result, 0, size);
        return result;
    }

    private void readJSONObjectStart() throws TException {
        this.context_.read();
        this.readJSONSyntaxChar(LBRACE);
        this.pushContext(new JSONPairContext());
    }

    private void readJSONObjectEnd() throws TException {
        this.readJSONSyntaxChar(RBRACE);
        this.popContext();
    }

    private void readJSONArrayStart() throws TException {
        this.context_.read();
        this.readJSONSyntaxChar(LBRACKET);
        this.pushContext(new JSONListContext());
    }

    private void readJSONArrayEnd() throws TException {
        this.readJSONSyntaxChar(RBRACKET);
        this.popContext();
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        this.readJSONArrayStart();
        try {
            String name = this.readJSONString().toString(StandardCharsets.UTF_8.name());
            byte type = (byte)this.readJSONInteger();
            int seqid = (int)this.readJSONInteger();
            return new TMessage(name, type, seqid);
        }
        catch (Exception e) {
            throw new TException();
        }
    }

    @Override
    public void readMessageEnd() throws TException {
        this.readJSONArrayEnd();
    }

    @Override
    public TStruct readStructBegin(Map<Integer, FieldMetaData> fieldMetadata) throws TException {
        if (this.currentReadContext != null) {
            this.readContexts.push(this.currentReadContext);
        }
        HashMap<String, Integer> namesToIds = new HashMap<String, Integer>(fieldMetadata.size());
        HashMap<Integer, TField> metadatas = new HashMap<Integer, TField>(fieldMetadata.size());
        for (Map.Entry<Integer, FieldMetaData> entry : fieldMetadata.entrySet()) {
            int fieldId = entry.getKey();
            FieldMetaData metadata = entry.getValue();
            TField tField = new TField(metadata.fieldName, metadata.valueMetaData.type, (short)fieldId);
            namesToIds.put(metadata.fieldName, fieldId);
            metadatas.put(fieldId, tField);
        }
        this.currentReadContext = new StructReadContext(namesToIds, metadatas);
        this.readJSONObjectStart();
        return ANONYMOUS_STRUCT;
    }

    @Override
    public TStruct readStructBegin() {
        throw new UnsupportedOperationException("You need to specify a \"field name\" -> \"field Id\" mapping to deserialize with TSimpleJSON");
    }

    @Override
    public void readStructEnd() throws TException {
        this.currentReadContext = this.readContexts.isEmpty() ? null : this.readContexts.pop();
        this.readJSONObjectEnd();
    }

    @Override
    public TField readFieldBegin() throws TException {
        if (this.reader_.peek() == RBRACE[0]) {
            return new TField("", 0, 0);
        }
        this.context_.read();
        try {
            String fieldName = this.readJSONString().toString(StandardCharsets.UTF_8.name());
            Integer fieldId = this.currentReadContext.namesToIds.get(fieldName);
            if (fieldId == null) {
                return new TField(fieldName, TSimpleJSONProtocol.getTypeIDForPeekedByte(this.reader_.peekNext()), 0);
            }
            return this.currentReadContext.fieldMetadata.get(fieldId);
        }
        catch (Exception e) {
            throw new TException(e);
        }
    }

    @Override
    public void readFieldEnd() throws TException {
    }

    @Override
    public TMap readMapBegin() throws TException {
        this.readJSONObjectStart();
        return new TMap(TSimpleJSONProtocol.getTypeIDForPeekedByte(this.reader_.peek()), 0, -1);
    }

    @Override
    public boolean peekMap() throws TException {
        return this.reader_.peek() != RBRACE[0];
    }

    @Override
    public void readMapEnd() throws TException {
        this.readJSONObjectEnd();
    }

    @Override
    public TList readListBegin() throws TException {
        this.readJSONArrayStart();
        return new TList(TSimpleJSONProtocol.getTypeIDForPeekedByte(this.reader_.peek()), -1);
    }

    @Override
    public boolean peekList() throws TException {
        return this.reader_.peek() != RBRACKET[0];
    }

    @Override
    public void readListEnd() throws TException {
        this.readJSONArrayEnd();
    }

    @Override
    public TSet readSetBegin() throws TException {
        this.readJSONArrayStart();
        return new TSet(TSimpleJSONProtocol.getTypeIDForPeekedByte(this.reader_.peek()), -1);
    }

    @Override
    public boolean peekSet() throws TException {
        return this.reader_.peek() != RBRACKET[0];
    }

    @Override
    public void readSetEnd() throws TException {
        this.readJSONArrayEnd();
    }

    @Override
    public boolean readBool() throws TException {
        boolean value;
        boolean hasQuote;
        this.context_.read();
        byte peek = this.reader_.peek();
        boolean bl = hasQuote = peek == QUOTE[0];
        if (hasQuote) {
            this.readJSONSyntaxChar(QUOTE);
        }
        if ((peek = this.reader_.peek()) == BOOL_TRUE[0]) {
            this.readJSONSyntaxString(BOOL_TRUE);
            value = true;
        } else if (peek == BOOL_FALSE[0]) {
            this.readJSONSyntaxString(BOOL_FALSE);
            value = false;
        } else {
            throw new TException(String.format("unexpected first char '%c', it doesn't match 'true' nor 'false'", peek));
        }
        if (hasQuote) {
            this.readJSONSyntaxChar(QUOTE);
        }
        return value;
    }

    @Override
    public byte readByte() throws TException {
        return (byte)this.readJSONInteger();
    }

    @Override
    public short readI16() throws TException {
        return (short)this.readJSONInteger();
    }

    @Override
    public int readI32() throws TException {
        return (int)this.readJSONInteger();
    }

    @Override
    public long readI64() throws TException {
        return this.readJSONInteger();
    }

    @Override
    public double readDouble() throws TException {
        return this.readJSONDouble();
    }

    @Override
    public float readFloat() throws TException {
        return this.readJSONFloat();
    }

    @Override
    public String readString() throws TException {
        this.context_.read();
        try {
            return this.readJSONString().toString(StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            throw new TException(e);
        }
    }

    @Override
    public byte[] readBinary() throws TException {
        return this.readString().getBytes(StandardCharsets.UTF_8);
    }

    protected static final byte getTypeIDForPeekedByte(byte peekedByte) throws TException {
        switch (peekedByte) {
            case 93: 
            case 125: {
                return 0;
            }
            case 123: {
                return 12;
            }
            case 91: {
                return 15;
            }
            case 102: 
            case 116: {
                return 2;
            }
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return 4;
            }
            case 34: {
                return 11;
            }
        }
        throw new TProtocolException(5, "Unrecognized peeked byte: " + (char)peekedByte);
    }

    public static class CollectionMapKeyException
    extends TException {
        public CollectionMapKeyException(String message) {
            super(message);
        }
    }

    protected class JSONPairContext
    extends JSONBaseContext {
        private boolean first_;
        private boolean colon_;

        protected JSONPairContext() {
            this.first_ = true;
            this.colon_ = true;
        }

        @Override
        protected void write() throws TException {
            if (this.first_) {
                this.first_ = false;
                this.colon_ = true;
            } else {
                TSimpleJSONProtocol.this.trans_.write(this.colon_ ? COLON : COMMA);
                this.colon_ = !this.colon_;
            }
        }

        @Override
        protected void read() throws TException {
            if (this.first_) {
                this.first_ = false;
            } else {
                byte[] expected = this.colon_ ? COLON : COMMA;
                this.colon_ = !this.colon_;
                TSimpleJSONProtocol.this.readJSONSyntaxChar(expected);
            }
        }

        @Override
        protected boolean escapeNum() {
            try {
                return TSimpleJSONProtocol.this.reader_.peek() == QUOTE[0];
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected class JSONListContext
    extends JSONBaseContext {
        private boolean first_;

        protected JSONListContext() {
            this.first_ = true;
        }

        @Override
        protected void write() throws TException {
            if (this.first_) {
                this.first_ = false;
            } else {
                TSimpleJSONProtocol.this.trans_.write(COMMA);
            }
        }

        @Override
        protected void read() throws TException {
            if (this.first_) {
                this.first_ = false;
            } else {
                TSimpleJSONProtocol.this.readJSONSyntaxChar(COMMA);
            }
        }
    }

    protected class JSONBaseContext {
        protected JSONBaseContext() {
        }

        protected void write() throws TException {
        }

        protected void read() throws TException {
        }

        protected boolean escapeNum() {
            return false;
        }
    }

    protected class LookaheadReader {
        private boolean hasData_;
        private byte[] data_ = new byte[1];
        private boolean hasNextData_ = false;
        private byte[] nextData_ = new byte[1];

        protected LookaheadReader() {
        }

        protected byte read(boolean skip) throws TException {
            if (this.hasNextData_) {
                byte result = this.data_[0];
                this.data_[0] = this.nextData_[0];
                this.hasNextData_ = false;
                return result;
            }
            if (this.hasData_) {
                this.hasData_ = false;
            } else {
                this.readDirectly(this.data_, skip);
            }
            return this.data_[0];
        }

        protected byte read() throws TException {
            return this.read(true);
        }

        private byte peek() throws TException {
            if (!this.hasData_) {
                this.read();
            }
            this.hasData_ = true;
            return this.data_[0];
        }

        private byte peekNext() throws TException {
            if (!this.hasNextData_) {
                this.peek();
                this.readDirectly(this.nextData_);
                this.hasNextData_ = true;
            }
            return this.nextData_[0];
        }

        private void readDirectly(byte[] data) {
            this.readDirectly(data, true);
        }

        private void readDirectly(byte[] data, boolean skip) {
            byte b;
            do {
                TSimpleJSONProtocol.this.trans_.readAll(data, 0, 1);
                b = data[0];
            } while (skip && (b == 32 || b == 9 || b == 10 || b == 13));
        }
    }

    private class StructReadContext {
        final Map<String, Integer> namesToIds;
        final Map<Integer, TField> fieldMetadata;

        StructReadContext(Map<String, Integer> namesToIds, Map<Integer, TField> fieldMetadata) {
            this.namesToIds = namesToIds;
            this.fieldMetadata = fieldMetadata;
        }
    }

    protected class MapContext
    extends StructContext {
        protected boolean isKey;

        protected MapContext() {
            this.isKey = true;
        }

        @Override
        protected void write() throws TException {
            super.write();
            this.isKey = !this.isKey;
        }

        @Override
        protected boolean isMapKey() {
            return this.isKey;
        }
    }

    protected class StructContext
    extends Context {
        protected boolean first_;
        protected boolean colon_;

        protected StructContext() {
            this.first_ = true;
            this.colon_ = true;
        }

        @Override
        protected void write() throws TException {
            if (this.first_) {
                this.first_ = false;
                this.colon_ = true;
            } else {
                TSimpleJSONProtocol.this.trans_.write(this.colon_ ? COLON : COMMA);
                this.colon_ = !this.colon_;
            }
        }
    }

    protected class ListContext
    extends Context {
        protected boolean first_;

        protected ListContext() {
            this.first_ = true;
        }

        @Override
        protected void write() throws TException {
            if (this.first_) {
                this.first_ = false;
            } else {
                TSimpleJSONProtocol.this.trans_.write(COMMA);
            }
        }
    }

    protected class Context {
        protected Context() {
        }

        protected void write() throws TException {
        }

        protected boolean isMapKey() {
            return false;
        }
    }

    public static class Factory
    implements TProtocolFactory {
        @Override
        public TProtocol getProtocol(TTransport trans) {
            return new TSimpleJSONProtocol(trans);
        }
    }
}

