/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command.clean;

import java.util.Collections;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.api.output.CommandResultFactory;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.command.clean.CleanExecutor;
import org.flywaydb.core.internal.command.clean.CleanModeConfigurationExtension;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.StringUtils;

public class DbClean {
    private static final Log LOG = LogFactory.getLog(DbClean.class);
    private final SchemaHistory schemaHistory;
    protected final Schema defaultSchema;
    protected final Schema[] schemas;
    protected final Connection connection;
    protected final Database database;
    protected final CallbackExecutor callbackExecutor;
    protected final Configuration configuration;

    public DbClean(Database database, SchemaHistory schemaHistory, Schema defaultSchema, Schema[] schemas, CallbackExecutor callbackExecutor, Configuration configuration) {
        this.schemaHistory = schemaHistory;
        this.defaultSchema = defaultSchema;
        this.schemas = schemas;
        this.connection = database.getMainConnection();
        this.database = database;
        this.callbackExecutor = callbackExecutor;
        this.configuration = configuration;
    }

    public CleanResult clean() throws FlywayException {
        CleanResult cleanResult;
        if (this.configuration.isCleanDisabled()) {
            throw new FlywayException("Unable to execute clean as it has been disabled with the 'flyway.cleanDisabled' property.");
        }
        this.callbackExecutor.onEvent(Event.BEFORE_CLEAN);
        String command = DbClean.toCommand(ConfigUtils.getCleanModel(this.configuration).getMode());
        if ("clean".equals(command)) {
            cleanResult = CommandResultFactory.createCleanResult(this.database.getCatalog());
            new CleanExecutor(this.connection, this.database, this.schemaHistory, this.callbackExecutor).clean(this.defaultSchema, this.schemas, cleanResult);
        } else {
            cleanResult = this.configuration.getPluginRegister().getPlugins(CommandExtension.class).stream().filter(e -> e.handlesCommand(command)).findFirst().map(e -> (CleanResult)e.handle(command, this.configuration, Collections.emptyList(), null)).orElseThrow(() -> new FlywayException("No command extension found to handle command " + command));
        }
        this.callbackExecutor.onEvent(Event.AFTER_CLEAN);
        this.schemaHistory.clearCache();
        return cleanResult;
    }

    public static String toCommand(String mode) {
        if (!StringUtils.hasText(mode)) {
            return "clean";
        }
        try {
            switch (CleanModeConfigurationExtension.Mode.valueOf(mode.toUpperCase())) {
                case SCHEMA: {
                    return "clean-schemas";
                }
                case ALL: {
                    return "clean-all";
                }
            }
            return "clean";
        }
        catch (IllegalArgumentException e) {
            return mode;
        }
    }
}

