/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Timer;
import io.greptime.common.util.Clock;
import io.greptime.common.util.Ensures;
import io.greptime.common.util.MetricsUtil;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializingExecutor
implements Executor {
    private static final Logger LOG = LoggerFactory.getLogger(SerializingExecutor.class);
    private static final int QUEUE_SIZE_THRESHOLD = 512;
    private final String name;
    private final Timer singleTaskTimer;
    private final Timer drainTimer;
    private final Histogram drainNumHis;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicReference<Thread> drainingThread = new AtomicReference();

    public SerializingExecutor(String name) {
        this(name, LogUncaughtExceptionHandler.INSTANCE);
    }

    public SerializingExecutor(String name, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.name = name;
        this.singleTaskTimer = MetricsUtil.timer("serializing_executor_single_task_timer", name);
        this.drainTimer = MetricsUtil.timer("serializing_executor_drain_timer", name);
        this.drainNumHis = MetricsUtil.histogram("serializing_executor_drain_num", name);
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public final void executeLater(Runnable task) {
        this.queue.add(Ensures.ensureNonNull(task, "null `task`"));
    }

    @Override
    public final void execute(Runnable task) {
        this.executeLater(task);
        this.drain();
    }

    public final void drain() {
        this.drainTimer.time(this::drain0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain0() {
        int drained = 0;
        do {
            if (!this.drainingThread.compareAndSet(null, Thread.currentThread())) {
                return;
            }
            try {
                Runnable task;
                while ((task = this.queue.poll()) != null) {
                    ++drained;
                    long startCall = Clock.defaultClock().getTick();
                    try {
                        task.run();
                    }
                    catch (Throwable t) {
                        this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), t);
                    }
                    finally {
                        this.singleTaskTimer.update(Clock.defaultClock().duration(startCall), TimeUnit.MILLISECONDS);
                    }
                }
            }
            finally {
                this.drainingThread.set(null);
            }
        } while (!this.queue.isEmpty());
        if (drained > 0) {
            this.drainNumHis.update(drained);
        }
        if (drained > 512) {
            LOG.warn("There were too many task [{}] in the queue [{}].", (Object)drained, (Object)this);
        }
    }

    public String toString() {
        return "SerializingExecutor{name='" + this.name + '\'' + '}';
    }

    private static enum LogUncaughtExceptionHandler implements Thread.UncaughtExceptionHandler
    {
        INSTANCE;


        @Override
        public void uncaughtException(Thread t, Throwable err) {
            LOG.error("Uncaught exception in thread {}.", (Object)t, (Object)err);
        }
    }
}

